/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.lineitem;

import io.vertx.core.impl.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.prebid.server.deals.lineitem.DeliveryPlan;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.lineitem.LostToLineItem;
import org.prebid.server.deals.proto.report.Event;

public final class LineItemStatus {
    private final String lineItemId;
    private final String source;
    private final String dealId;
    private final String extLineItemId;
    private final String accountId;
    private final LongAdder domainMatched;
    private final LongAdder targetMatched;
    private final LongAdder targetMatchedButFcapped;
    private final LongAdder targetMatchedButFcapLookupFailed;
    private final LongAdder pacingDeferred;
    private final LongAdder sentToBidder;
    private final LongAdder sentToBidderAsTopMatch;
    private final LongAdder receivedFromBidder;
    private final LongAdder receivedFromBidderInvalidated;
    private final LongAdder sentToClient;
    private final LongAdder sentToClientAsTopMatch;
    private final Set<LostToLineItem> lostToLineItems;
    private final Set<Event> events;
    private final Set<DeliveryPlan> deliveryPlans;

    private LineItemStatus(String lineItemId, String source, String dealId, String extLineItemId, String accountId) {
        this.lineItemId = lineItemId;
        this.source = source;
        this.dealId = dealId;
        this.extLineItemId = extLineItemId;
        this.accountId = accountId;
        this.domainMatched = new LongAdder();
        this.targetMatched = new LongAdder();
        this.targetMatchedButFcapped = new LongAdder();
        this.targetMatchedButFcapLookupFailed = new LongAdder();
        this.pacingDeferred = new LongAdder();
        this.sentToBidder = new LongAdder();
        this.sentToBidderAsTopMatch = new LongAdder();
        this.receivedFromBidder = new LongAdder();
        this.receivedFromBidderInvalidated = new LongAdder();
        this.sentToClient = new LongAdder();
        this.sentToClientAsTopMatch = new LongAdder();
        this.lostToLineItems = new ConcurrentHashSet();
        this.events = new ConcurrentHashSet();
        this.deliveryPlans = new ConcurrentHashSet();
    }

    public static LineItemStatus of(String lineItemId, String source, String dealId, String extLineItemId, String accountId) {
        return new LineItemStatus(lineItemId, source, dealId, extLineItemId, accountId);
    }

    public static LineItemStatus of(LineItem lineItem) {
        return new LineItemStatus(lineItem.getLineItemId(), lineItem.getSource(), lineItem.getDealId(), lineItem.getExtLineItemId(), lineItem.getAccountId());
    }

    public static LineItemStatus of(String lineItemId) {
        return new LineItemStatus(lineItemId, null, null, null, null);
    }

    public void incDomainMatched() {
        this.domainMatched.increment();
    }

    public void incTargetMatched() {
        this.targetMatched.increment();
    }

    public void incTargetMatchedButFcapped() {
        this.targetMatchedButFcapped.increment();
    }

    public void incTargetMatchedButFcapLookupFailed() {
        this.targetMatchedButFcapLookupFailed.increment();
    }

    public void incPacingDeferred() {
        this.pacingDeferred.increment();
    }

    public void incSentToBidder() {
        this.sentToBidder.increment();
    }

    public void incSentToBidderAsTopMatch() {
        this.sentToBidderAsTopMatch.increment();
    }

    public void incReceivedFromBidder() {
        this.receivedFromBidder.increment();
    }

    public void incReceivedFromBidderInvalidated() {
        this.receivedFromBidderInvalidated.increment();
    }

    public void incSentToClient() {
        this.sentToClient.increment();
    }

    public void incSentToClientAsTopMatch() {
        this.sentToClientAsTopMatch.increment();
    }

    public void merge(LineItemStatus other) {
        this.domainMatched.add(other.domainMatched.sum());
        this.targetMatched.add(other.targetMatched.sum());
        this.targetMatchedButFcapped.add(other.targetMatchedButFcapped.sum());
        this.targetMatchedButFcapLookupFailed.add(other.getTargetMatchedButFcapLookupFailed().sum());
        this.pacingDeferred.add(other.pacingDeferred.sum());
        this.sentToBidder.add(other.sentToBidder.sum());
        this.sentToBidderAsTopMatch.add(other.sentToBidderAsTopMatch.sum());
        this.receivedFromBidder.add(other.receivedFromBidder.sum());
        this.receivedFromBidderInvalidated.add(other.receivedFromBidderInvalidated.sum());
        this.sentToClient.add(other.sentToClient.sum());
        this.sentToClientAsTopMatch.add(other.sentToClientAsTopMatch.sum());
        this.mergeEvents(other);
    }

    private void mergeEvents(LineItemStatus other) {
        Map typesToEvent = other.events.stream().collect(Collectors.toMap(Event::getType, Function.identity()));
        typesToEvent.forEach(this::addOrUpdateEvent);
    }

    private void addOrUpdateEvent(String type, Event distEvent) {
        Event sameTypeEvent = this.events.stream().filter(event -> event.getType().equals(type)).findFirst().orElse(null);
        if (sameTypeEvent != null) {
            sameTypeEvent.getCount().add(distEvent.getCount().sum());
        } else {
            this.events.add(distEvent);
        }
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public String getSource() {
        return this.source;
    }

    public String getDealId() {
        return this.dealId;
    }

    public String getExtLineItemId() {
        return this.extLineItemId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LongAdder getDomainMatched() {
        return this.domainMatched;
    }

    public LongAdder getTargetMatched() {
        return this.targetMatched;
    }

    public LongAdder getTargetMatchedButFcapped() {
        return this.targetMatchedButFcapped;
    }

    public LongAdder getTargetMatchedButFcapLookupFailed() {
        return this.targetMatchedButFcapLookupFailed;
    }

    public LongAdder getPacingDeferred() {
        return this.pacingDeferred;
    }

    public LongAdder getSentToBidder() {
        return this.sentToBidder;
    }

    public LongAdder getSentToBidderAsTopMatch() {
        return this.sentToBidderAsTopMatch;
    }

    public LongAdder getReceivedFromBidder() {
        return this.receivedFromBidder;
    }

    public LongAdder getReceivedFromBidderInvalidated() {
        return this.receivedFromBidderInvalidated;
    }

    public LongAdder getSentToClient() {
        return this.sentToClient;
    }

    public LongAdder getSentToClientAsTopMatch() {
        return this.sentToClientAsTopMatch;
    }

    public Set<LostToLineItem> getLostToLineItems() {
        return this.lostToLineItems;
    }

    public Set<Event> getEvents() {
        return this.events;
    }

    public Set<DeliveryPlan> getDeliveryPlans() {
        return this.deliveryPlans;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineItemStatus)) {
            return false;
        }
        LineItemStatus other = (LineItemStatus)o;
        String this$lineItemId = this.getLineItemId();
        String other$lineItemId = other.getLineItemId();
        if (this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$dealId = this.getDealId();
        String other$dealId = other.getDealId();
        if (this$dealId == null ? other$dealId != null : !this$dealId.equals(other$dealId)) {
            return false;
        }
        String this$extLineItemId = this.getExtLineItemId();
        String other$extLineItemId = other.getExtLineItemId();
        if (this$extLineItemId == null ? other$extLineItemId != null : !this$extLineItemId.equals(other$extLineItemId)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        LongAdder this$domainMatched = this.getDomainMatched();
        LongAdder other$domainMatched = other.getDomainMatched();
        if (this$domainMatched == null ? other$domainMatched != null : !this$domainMatched.equals(other$domainMatched)) {
            return false;
        }
        LongAdder this$targetMatched = this.getTargetMatched();
        LongAdder other$targetMatched = other.getTargetMatched();
        if (this$targetMatched == null ? other$targetMatched != null : !this$targetMatched.equals(other$targetMatched)) {
            return false;
        }
        LongAdder this$targetMatchedButFcapped = this.getTargetMatchedButFcapped();
        LongAdder other$targetMatchedButFcapped = other.getTargetMatchedButFcapped();
        if (this$targetMatchedButFcapped == null ? other$targetMatchedButFcapped != null : !this$targetMatchedButFcapped.equals(other$targetMatchedButFcapped)) {
            return false;
        }
        LongAdder this$targetMatchedButFcapLookupFailed = this.getTargetMatchedButFcapLookupFailed();
        LongAdder other$targetMatchedButFcapLookupFailed = other.getTargetMatchedButFcapLookupFailed();
        if (this$targetMatchedButFcapLookupFailed == null ? other$targetMatchedButFcapLookupFailed != null : !this$targetMatchedButFcapLookupFailed.equals(other$targetMatchedButFcapLookupFailed)) {
            return false;
        }
        LongAdder this$pacingDeferred = this.getPacingDeferred();
        LongAdder other$pacingDeferred = other.getPacingDeferred();
        if (this$pacingDeferred == null ? other$pacingDeferred != null : !this$pacingDeferred.equals(other$pacingDeferred)) {
            return false;
        }
        LongAdder this$sentToBidder = this.getSentToBidder();
        LongAdder other$sentToBidder = other.getSentToBidder();
        if (this$sentToBidder == null ? other$sentToBidder != null : !this$sentToBidder.equals(other$sentToBidder)) {
            return false;
        }
        LongAdder this$sentToBidderAsTopMatch = this.getSentToBidderAsTopMatch();
        LongAdder other$sentToBidderAsTopMatch = other.getSentToBidderAsTopMatch();
        if (this$sentToBidderAsTopMatch == null ? other$sentToBidderAsTopMatch != null : !this$sentToBidderAsTopMatch.equals(other$sentToBidderAsTopMatch)) {
            return false;
        }
        LongAdder this$receivedFromBidder = this.getReceivedFromBidder();
        LongAdder other$receivedFromBidder = other.getReceivedFromBidder();
        if (this$receivedFromBidder == null ? other$receivedFromBidder != null : !this$receivedFromBidder.equals(other$receivedFromBidder)) {
            return false;
        }
        LongAdder this$receivedFromBidderInvalidated = this.getReceivedFromBidderInvalidated();
        LongAdder other$receivedFromBidderInvalidated = other.getReceivedFromBidderInvalidated();
        if (this$receivedFromBidderInvalidated == null ? other$receivedFromBidderInvalidated != null : !this$receivedFromBidderInvalidated.equals(other$receivedFromBidderInvalidated)) {
            return false;
        }
        LongAdder this$sentToClient = this.getSentToClient();
        LongAdder other$sentToClient = other.getSentToClient();
        if (this$sentToClient == null ? other$sentToClient != null : !this$sentToClient.equals(other$sentToClient)) {
            return false;
        }
        LongAdder this$sentToClientAsTopMatch = this.getSentToClientAsTopMatch();
        LongAdder other$sentToClientAsTopMatch = other.getSentToClientAsTopMatch();
        if (this$sentToClientAsTopMatch == null ? other$sentToClientAsTopMatch != null : !this$sentToClientAsTopMatch.equals(other$sentToClientAsTopMatch)) {
            return false;
        }
        Set<LostToLineItem> this$lostToLineItems = this.getLostToLineItems();
        Set<LostToLineItem> other$lostToLineItems = other.getLostToLineItems();
        if (this$lostToLineItems == null ? other$lostToLineItems != null : !((Object)this$lostToLineItems).equals(other$lostToLineItems)) {
            return false;
        }
        Set<Event> this$events = this.getEvents();
        Set<Event> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        Set<DeliveryPlan> this$deliveryPlans = this.getDeliveryPlans();
        Set<DeliveryPlan> other$deliveryPlans = other.getDeliveryPlans();
        return !(this$deliveryPlans == null ? other$deliveryPlans != null : !((Object)this$deliveryPlans).equals(other$deliveryPlans));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $lineItemId = this.getLineItemId();
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $dealId = this.getDealId();
        result = result * 59 + ($dealId == null ? 43 : $dealId.hashCode());
        String $extLineItemId = this.getExtLineItemId();
        result = result * 59 + ($extLineItemId == null ? 43 : $extLineItemId.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        LongAdder $domainMatched = this.getDomainMatched();
        result = result * 59 + ($domainMatched == null ? 43 : $domainMatched.hashCode());
        LongAdder $targetMatched = this.getTargetMatched();
        result = result * 59 + ($targetMatched == null ? 43 : $targetMatched.hashCode());
        LongAdder $targetMatchedButFcapped = this.getTargetMatchedButFcapped();
        result = result * 59 + ($targetMatchedButFcapped == null ? 43 : $targetMatchedButFcapped.hashCode());
        LongAdder $targetMatchedButFcapLookupFailed = this.getTargetMatchedButFcapLookupFailed();
        result = result * 59 + ($targetMatchedButFcapLookupFailed == null ? 43 : $targetMatchedButFcapLookupFailed.hashCode());
        LongAdder $pacingDeferred = this.getPacingDeferred();
        result = result * 59 + ($pacingDeferred == null ? 43 : $pacingDeferred.hashCode());
        LongAdder $sentToBidder = this.getSentToBidder();
        result = result * 59 + ($sentToBidder == null ? 43 : $sentToBidder.hashCode());
        LongAdder $sentToBidderAsTopMatch = this.getSentToBidderAsTopMatch();
        result = result * 59 + ($sentToBidderAsTopMatch == null ? 43 : $sentToBidderAsTopMatch.hashCode());
        LongAdder $receivedFromBidder = this.getReceivedFromBidder();
        result = result * 59 + ($receivedFromBidder == null ? 43 : $receivedFromBidder.hashCode());
        LongAdder $receivedFromBidderInvalidated = this.getReceivedFromBidderInvalidated();
        result = result * 59 + ($receivedFromBidderInvalidated == null ? 43 : $receivedFromBidderInvalidated.hashCode());
        LongAdder $sentToClient = this.getSentToClient();
        result = result * 59 + ($sentToClient == null ? 43 : $sentToClient.hashCode());
        LongAdder $sentToClientAsTopMatch = this.getSentToClientAsTopMatch();
        result = result * 59 + ($sentToClientAsTopMatch == null ? 43 : $sentToClientAsTopMatch.hashCode());
        Set<LostToLineItem> $lostToLineItems = this.getLostToLineItems();
        result = result * 59 + ($lostToLineItems == null ? 43 : ((Object)$lostToLineItems).hashCode());
        Set<Event> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        Set<DeliveryPlan> $deliveryPlans = this.getDeliveryPlans();
        result = result * 59 + ($deliveryPlans == null ? 43 : ((Object)$deliveryPlans).hashCode());
        return result;
    }

    public String toString() {
        return "LineItemStatus(lineItemId=" + this.getLineItemId() + ", source=" + this.getSource() + ", dealId=" + this.getDealId() + ", extLineItemId=" + this.getExtLineItemId() + ", accountId=" + this.getAccountId() + ", domainMatched=" + this.getDomainMatched() + ", targetMatched=" + this.getTargetMatched() + ", targetMatchedButFcapped=" + this.getTargetMatchedButFcapped() + ", targetMatchedButFcapLookupFailed=" + this.getTargetMatchedButFcapLookupFailed() + ", pacingDeferred=" + this.getPacingDeferred() + ", sentToBidder=" + this.getSentToBidder() + ", sentToBidderAsTopMatch=" + this.getSentToBidderAsTopMatch() + ", receivedFromBidder=" + this.getReceivedFromBidder() + ", receivedFromBidderInvalidated=" + this.getReceivedFromBidderInvalidated() + ", sentToClient=" + this.getSentToClient() + ", sentToClientAsTopMatch=" + this.getSentToClientAsTopMatch() + ", lostToLineItems=" + this.getLostToLineItems() + ", events=" + this.getEvents() + ", deliveryPlans=" + this.getDeliveryPlans() + ")";
    }
}

