/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.BidInfo;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.cache.model.CacheBid;
import org.prebid.server.cache.model.CacheContext;
import org.prebid.server.cache.model.CacheHttpRequest;
import org.prebid.server.cache.model.CacheHttpResponse;
import org.prebid.server.cache.model.CacheInfo;
import org.prebid.server.cache.model.CacheServiceResult;
import org.prebid.server.cache.model.CacheTtl;
import org.prebid.server.cache.model.DebugHttpCall;
import org.prebid.server.cache.proto.request.BidCacheRequest;
import org.prebid.server.cache.proto.request.PutObject;
import org.prebid.server.cache.proto.response.BidCacheResponse;
import org.prebid.server.cache.proto.response.CacheObject;
import org.prebid.server.events.EventsContext;
import org.prebid.server.events.EventsService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.identity.UUIDIdGenerator;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.vast.VastModifier;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

public class CacheService {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private static final MultiMap CACHE_HEADERS = HttpUtil.headers();
    private static final Map<String, List<String>> DEBUG_HEADERS = HttpUtil.toDebugHeaders(CACHE_HEADERS);
    private static final String BID_WURL_ATTRIBUTE = "wurl";
    private static final String XML_CREATIVE_TYPE = "xml";
    private static final String JSON_CREATIVE_TYPE = "json";
    private final CacheTtl mediaTypeCacheTtl;
    private final HttpClient httpClient;
    private final URL endpointUrl;
    private final String cachedAssetUrlTemplate;
    private final long expectedCacheTimeMs;
    private final VastModifier vastModifier;
    private final EventsService eventsService;
    private final Metrics metrics;
    private final Clock clock;
    private final UUIDIdGenerator idGenerator;
    private final JacksonMapper mapper;

    public CacheService(CacheTtl mediaTypeCacheTtl, HttpClient httpClient, URL endpointUrl, String cachedAssetUrlTemplate, long expectedCacheTimeMs, VastModifier vastModifier, EventsService eventsService, Metrics metrics, Clock clock, UUIDIdGenerator idGenerator, JacksonMapper mapper) {
        this.mediaTypeCacheTtl = Objects.requireNonNull(mediaTypeCacheTtl);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.endpointUrl = Objects.requireNonNull(endpointUrl);
        this.cachedAssetUrlTemplate = Objects.requireNonNull(cachedAssetUrlTemplate);
        this.expectedCacheTimeMs = expectedCacheTimeMs;
        this.vastModifier = Objects.requireNonNull(vastModifier);
        this.eventsService = Objects.requireNonNull(eventsService);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public String getEndpointHost() {
        String host = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        return port != -1 ? "%s:%d".formatted(host, port) : host;
    }

    public String getEndpointPath() {
        return this.endpointUrl.getPath();
    }

    public String getCachedAssetURLTemplate() {
        return this.cachedAssetUrlTemplate;
    }

    public String cacheVideoDebugLog(CachedDebugLog cachedDebugLog, Integer videoCacheTtl) {
        String cacheKey = cachedDebugLog.getCacheKey() == null ? this.idGenerator.generateId() : cachedDebugLog.getCacheKey();
        List<CachedCreative> cachedCreatives = Collections.singletonList(this.makeDebugCacheCreative(cachedDebugLog, cacheKey, videoCacheTtl));
        BidCacheRequest bidCacheRequest = this.toBidCacheRequest(cachedCreatives);
        this.httpClient.post(this.endpointUrl.toString(), HttpUtil.headers(), this.mapper.encodeToString(bidCacheRequest), this.expectedCacheTimeMs);
        return cacheKey;
    }

    private CachedCreative makeDebugCacheCreative(CachedDebugLog videoCacheDebugLog, String hbCacheId, Integer videoCacheTtl) {
        JsonNode value = this.mapper.mapper().valueToTree((Object)videoCacheDebugLog.buildCacheBody());
        videoCacheDebugLog.setCacheKey(hbCacheId);
        return CachedCreative.of(PutObject.builder().type(XML_CREATIVE_TYPE).value((JsonNode)new TextNode(videoCacheDebugLog.buildCacheBody())).expiry(videoCacheTtl != null ? videoCacheTtl.intValue() : videoCacheDebugLog.getTtl()).key("log_" + hbCacheId).build(), CacheService.creativeSizeFromTextNode(value));
    }

    private Future<BidCacheResponse> makeRequest(BidCacheRequest bidCacheRequest, int bidCount, Timeout timeout, String accountId) {
        if (bidCount == 0) {
            return Future.succeededFuture((Object)BidCacheResponse.of(Collections.emptyList()));
        }
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return Future.failedFuture((Throwable)new TimeoutException("Timeout has been exceeded"));
        }
        long startTime = this.clock.millis();
        return this.httpClient.post(this.endpointUrl.toString(), CACHE_HEADERS, this.mapper.encodeToString(bidCacheRequest), remainingTimeout).map(response -> this.toBidCacheResponse(response.getStatusCode(), response.getBody(), bidCount, accountId, startTime)).recover(exception -> this.failResponse((Throwable)exception, accountId, startTime));
    }

    private Future<BidCacheResponse> failResponse(Throwable exception, String accountId, long startTime) {
        this.metrics.updateCacheRequestFailedTime(accountId, this.clock.millis() - startTime);
        logger.warn((Object)"Error occurred while interacting with cache service: {0}", new Object[]{exception.getMessage()});
        logger.debug((Object)"Error occurred while interacting with cache service", exception);
        return Future.failedFuture((Throwable)exception);
    }

    public Future<BidCacheResponse> cachePutObjects(List<PutObject> putObjects, Boolean isEventsEnabled, Set<String> biddersAllowingVastUpdate, String accountId, String integration, Timeout timeout) {
        List<CachedCreative> cachedCreatives = this.updatePutObjects(putObjects, isEventsEnabled, biddersAllowingVastUpdate, accountId, integration);
        this.updateCreativeMetrics(accountId, cachedCreatives);
        return this.makeRequest(this.toBidCacheRequest(cachedCreatives), cachedCreatives.size(), timeout, accountId);
    }

    private List<CachedCreative> updatePutObjects(List<PutObject> putObjects, Boolean isEventsEnabled, Set<String> allowedBidders, String accountId, String integration) {
        return putObjects.stream().map(putObject -> putObject.toBuilder().bidid(null).bidder(null).timestamp(null).value(this.vastModifier.modifyVastXml(isEventsEnabled, allowedBidders, (PutObject)putObject, accountId, integration)).build()).map(payload -> CachedCreative.of(payload, CacheService.creativeSizeFromTextNode(payload.getValue()))).toList();
    }

    public Future<CacheServiceResult> cacheBidsOpenrtb(List<BidInfo> bidsToCache, AuctionContext auctionContext, CacheContext cacheContext, EventsContext eventsContext) {
        if (CollectionUtils.isEmpty(bidsToCache)) {
            return Future.succeededFuture((Object)CacheServiceResult.empty());
        }
        List<Imp> imps = auctionContext.getBidRequest().getImp();
        boolean isAnyEmptyExpImp = imps.stream().map(Imp::getExp).anyMatch(Objects::isNull);
        Account account = auctionContext.getAccount();
        CacheTtl accountCacheTtl = this.accountCacheTtl(isAnyEmptyExpImp, account);
        List<CacheBid> cacheBids = cacheContext.isShouldCacheBids() ? this.getCacheBids(bidsToCache, cacheContext.getCacheBidsTtl(), accountCacheTtl) : Collections.emptyList();
        List<CacheBid> videoCacheBids = cacheContext.isShouldCacheVideoBids() ? this.getVideoCacheBids(bidsToCache, cacheContext.getCacheVideoBidsTtl(), accountCacheTtl) : Collections.emptyList();
        return this.doCacheOpenrtb(cacheBids, videoCacheBids, auctionContext, eventsContext);
    }

    private CacheTtl accountCacheTtl(boolean impWithNoExpExists, Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        Integer bannerCacheTtl = accountAuctionConfig != null ? accountAuctionConfig.getBannerCacheTtl() : null;
        Integer videoCacheTtl = accountAuctionConfig != null ? accountAuctionConfig.getVideoCacheTtl() : null;
        return impWithNoExpExists && (bannerCacheTtl != null || videoCacheTtl != null) ? CacheTtl.of(bannerCacheTtl, videoCacheTtl) : CacheTtl.empty();
    }

    private List<CacheBid> getCacheBids(List<BidInfo> bidInfos, Integer cacheBidsTtl, CacheTtl accountCacheTtl) {
        return bidInfos.stream().map(bidInfo -> this.toCacheBid((BidInfo)bidInfo, cacheBidsTtl, accountCacheTtl, false)).toList();
    }

    private List<CacheBid> getVideoCacheBids(List<BidInfo> bidInfos, Integer cacheBidsTtl, CacheTtl accountCacheTtl) {
        return bidInfos.stream().filter(bidInfo -> Objects.equals((Object)bidInfo.getBidType(), (Object)BidType.video)).map(bidInfo -> this.toCacheBid((BidInfo)bidInfo, cacheBidsTtl, accountCacheTtl, true)).toList();
    }

    private CacheBid toCacheBid(BidInfo bidInfo, Integer requestTtl, CacheTtl accountCacheTtl, boolean isVideoBid) {
        Bid bid = bidInfo.getBid();
        Integer bidTtl = bid.getExp();
        Imp correspondingImp = bidInfo.getCorrespondingImp();
        Integer impTtl = correspondingImp != null ? correspondingImp.getExp() : null;
        Integer accountMediaTypeTtl = isVideoBid ? accountCacheTtl.getVideoCacheTtl() : accountCacheTtl.getBannerCacheTtl();
        Integer mediaTypeTtl = isVideoBid ? this.mediaTypeCacheTtl.getVideoCacheTtl() : this.mediaTypeCacheTtl.getBannerCacheTtl();
        Integer ttl = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{bidTtl, impTtl, requestTtl, accountMediaTypeTtl, mediaTypeTtl});
        return CacheBid.of(bidInfo, ttl);
    }

    private Future<CacheServiceResult> doCacheOpenrtb(List<CacheBid> bids, List<CacheBid> videoBids, AuctionContext auctionContext, EventsContext eventsContext) {
        long remainingTimeout;
        Account account = auctionContext.getAccount();
        String accountId = account.getId();
        String hbCacheId = videoBids.stream().anyMatch(cacheBid -> cacheBid.getBidInfo().getCategory() != null) ? this.idGenerator.generateId() : null;
        String requestId = auctionContext.getBidRequest().getId();
        List cachedCreatives = Stream.concat(bids.stream().map(cacheBid -> this.createJsonPutObjectOpenrtb((CacheBid)cacheBid, accountId, eventsContext)), videoBids.stream().map(videoBid -> this.createXmlPutObjectOpenrtb((CacheBid)videoBid, requestId, hbCacheId))).collect(Collectors.toCollection(ArrayList::new));
        if (cachedCreatives.isEmpty()) {
            return Future.succeededFuture((Object)CacheServiceResult.empty());
        }
        CachedDebugLog cachedDebugLog = auctionContext.getCachedDebugLog();
        Integer videoCacheTtl = ObjectUtil.getIfNotNull(account.getAuction(), AccountAuctionConfig::getVideoCacheTtl);
        if (CollectionUtils.isNotEmpty((Collection)cachedCreatives) && cachedDebugLog != null && cachedDebugLog.isEnabled()) {
            cachedCreatives.add(this.makeDebugCacheCreative(cachedDebugLog, hbCacheId, videoCacheTtl));
        }
        if ((remainingTimeout = auctionContext.getTimeout().remaining()) <= 0L) {
            return Future.succeededFuture((Object)CacheServiceResult.of(null, new TimeoutException("Timeout has been exceeded"), Collections.emptyMap()));
        }
        BidCacheRequest bidCacheRequest = this.toBidCacheRequest(cachedCreatives);
        this.updateCreativeMetrics(accountId, cachedCreatives);
        String url = this.endpointUrl.toString();
        String body = this.mapper.encodeToString(bidCacheRequest);
        CacheHttpRequest httpRequest = CacheHttpRequest.of(url, body);
        long startTime = this.clock.millis();
        return this.httpClient.post(url, CACHE_HEADERS, body, remainingTimeout).map(response -> this.processResponseOpenrtb((HttpClientResponse)response, httpRequest, cachedCreatives.size(), bids, videoBids, hbCacheId, accountId, startTime)).otherwise(exception -> this.failResponseOpenrtb((Throwable)exception, accountId, httpRequest, startTime));
    }

    private CacheServiceResult processResponseOpenrtb(HttpClientResponse response, CacheHttpRequest httpRequest, int bidCount, List<CacheBid> bids, List<CacheBid> videoBids, String hbCacheId, String accountId, long startTime) {
        BidCacheResponse bidCacheResponse;
        CacheHttpResponse httpResponse = CacheHttpResponse.of(response.getStatusCode(), response.getBody());
        int responseStatusCode = response.getStatusCode();
        DebugHttpCall httpCall = this.makeDebugHttpCall(this.endpointUrl.toString(), httpRequest, httpResponse, startTime);
        try {
            bidCacheResponse = this.toBidCacheResponse(responseStatusCode, response.getBody(), bidCount, accountId, startTime);
        }
        catch (PreBidException e) {
            return CacheServiceResult.of(httpCall, e, Collections.emptyMap());
        }
        List<String> uuids = this.toResponse(bidCacheResponse, CacheObject::getUuid);
        return CacheServiceResult.of(httpCall, null, CacheService.toResultMap(bids, videoBids, uuids, hbCacheId));
    }

    private CacheServiceResult failResponseOpenrtb(Throwable exception, String accountId, CacheHttpRequest request, long startTime) {
        logger.warn((Object)"Error occurred while interacting with cache service: {0}", new Object[]{exception.getMessage()});
        logger.debug((Object)"Error occurred while interacting with cache service", exception);
        this.metrics.updateCacheRequestFailedTime(accountId, this.clock.millis() - startTime);
        DebugHttpCall httpCall = this.makeDebugHttpCall(this.endpointUrl.toString(), request, null, startTime);
        return CacheServiceResult.of(httpCall, exception, Collections.emptyMap());
    }

    private DebugHttpCall makeDebugHttpCall(String endpoint, CacheHttpRequest httpRequest, CacheHttpResponse httpResponse, long startTime) {
        return DebugHttpCall.builder().endpoint(endpoint).requestUri(httpRequest != null ? httpRequest.getUri() : null).requestBody(httpRequest != null ? httpRequest.getBody() : null).responseStatus(httpResponse != null ? Integer.valueOf(httpResponse.getStatusCode()) : null).responseBody(httpResponse != null ? httpResponse.getBody() : null).responseTimeMillis(this.responseTime(startTime)).requestHeaders(DEBUG_HEADERS).build();
    }

    private int responseTime(long startTime) {
        return Math.toIntExact(this.clock.millis() - startTime);
    }

    private CachedCreative createJsonPutObjectOpenrtb(CacheBid cacheBid, String accountId, EventsContext eventsContext) {
        BidInfo bidInfo = cacheBid.getBidInfo();
        Bid bid = bidInfo.getBid();
        ObjectNode bidObjectNode = (ObjectNode)this.mapper.mapper().valueToTree((Object)bid);
        String eventUrl = this.generateWinUrl(bidInfo.getBidId(), bidInfo.getBidder(), accountId, eventsContext, bidInfo.getLineItemId());
        if (eventUrl != null) {
            bidObjectNode.put(BID_WURL_ATTRIBUTE, eventUrl);
        }
        PutObject payload = PutObject.builder().aid(eventsContext.getAuctionId()).type(JSON_CREATIVE_TYPE).value((JsonNode)bidObjectNode).ttlseconds(cacheBid.getTtl()).build();
        return CachedCreative.of(payload, CacheService.creativeSizeFromAdm(bid.getAdm()));
    }

    private CachedCreative createXmlPutObjectOpenrtb(CacheBid cacheBid, String requestId, String hbCacheId) {
        BidInfo bidInfo = cacheBid.getBidInfo();
        Bid bid = bidInfo.getBid();
        String vastXml = bid.getAdm();
        String customCacheKey = CacheService.resolveCustomCacheKey(hbCacheId, bidInfo.getCategory());
        PutObject payload = PutObject.builder().aid(requestId).type(XML_CREATIVE_TYPE).value((JsonNode)(vastXml != null ? new TextNode(vastXml) : null)).ttlseconds(cacheBid.getTtl()).key(customCacheKey).build();
        return CachedCreative.of(payload, CacheService.creativeSizeFromTextNode(payload.getValue()));
    }

    private static String resolveCustomCacheKey(String hbCacheId, String category) {
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{category, hbCacheId}) ? "%s_%s".formatted(category, hbCacheId) : null;
    }

    private String generateWinUrl(String bidId, String bidder, String accountId, EventsContext eventsContext, String lineItemId) {
        if (!eventsContext.isEnabledForAccount()) {
            return null;
        }
        if (eventsContext.isEnabledForRequest() || StringUtils.isNotBlank((CharSequence)lineItemId)) {
            return this.eventsService.winUrl(bidId, bidder, accountId, lineItemId, eventsContext.isEnabledForRequest(), eventsContext);
        }
        return null;
    }

    private BidCacheResponse toBidCacheResponse(int statusCode, String responseBody, int bidCount, String accountId, long startTime) {
        BidCacheResponse bidCacheResponse;
        if (statusCode != 200) {
            throw new PreBidException("HTTP status code " + statusCode);
        }
        try {
            bidCacheResponse = this.mapper.decodeValue(responseBody, BidCacheResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Cannot parse response: " + responseBody, e);
        }
        List<CacheObject> responses = bidCacheResponse.getResponses();
        if (responses == null || responses.size() != bidCount) {
            throw new PreBidException("The number of response cache objects doesn't match with bids");
        }
        this.metrics.updateCacheRequestSuccessTime(accountId, this.clock.millis() - startTime);
        return bidCacheResponse;
    }

    private <T> List<T> toResponse(BidCacheResponse bidCacheResponse, Function<CacheObject, T> responseItemCreator) {
        return bidCacheResponse.getResponses().stream().filter(Objects::nonNull).map(responseItemCreator).filter(Objects::nonNull).toList();
    }

    private static Map<Bid, CacheInfo> toResultMap(List<CacheBid> cacheBids, List<CacheBid> cacheVideoBids, List<String> uuids, String hbCacheId) {
        HashMap<Bid, CacheInfo> result = new HashMap<Bid, CacheInfo>(uuids.size());
        if (!cacheBids.isEmpty()) {
            List<Bid> videoBids = cacheVideoBids.stream().map(CacheBid::getBidInfo).map(BidInfo::getBid).toList();
            int bidsSize = cacheBids.size();
            for (int i = 0; i < bidsSize; ++i) {
                CacheBid cacheBid = cacheBids.get(i);
                BidInfo bidInfo = cacheBid.getBidInfo();
                Bid bid = bidInfo.getBid();
                Integer ttl = cacheBid.getTtl();
                int indexOfVideoBid = videoBids.indexOf(bid);
                String videoBidUuid = indexOfVideoBid != -1 ? uuids.get(bidsSize + indexOfVideoBid) : null;
                Integer videoTtl = indexOfVideoBid != -1 ? cacheVideoBids.get(indexOfVideoBid).getTtl() : null;
                result.put(bid, CacheInfo.of(uuids.get(i), CacheService.resolveVideoBidUuid(videoBidUuid, hbCacheId), ttl, videoTtl));
            }
        } else {
            for (int i = 0; i < cacheVideoBids.size(); ++i) {
                CacheBid cacheBid = cacheVideoBids.get(i);
                BidInfo bidInfo = cacheBid.getBidInfo();
                result.put(bidInfo.getBid(), CacheInfo.of(null, CacheService.resolveVideoBidUuid(uuids.get(i), hbCacheId), null, cacheBid.getTtl()));
            }
        }
        return result;
    }

    private static String resolveVideoBidUuid(String uuid, String hbCacheId) {
        return hbCacheId != null && uuid.endsWith(hbCacheId) ? hbCacheId : uuid;
    }

    public static URL getCacheEndpointUrl(String cacheSchema, String cacheHost, String path) {
        try {
            URL baseUrl = CacheService.getCacheBaseUrl(cacheSchema, cacheHost);
            return new URL(baseUrl, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not get cache endpoint for prebid cache service", e);
        }
    }

    public static String getCachedAssetUrlTemplate(String cacheSchema, String cacheHost, String path, String cacheQuery) {
        try {
            URL baseUrl = CacheService.getCacheBaseUrl(cacheSchema, cacheHost);
            return new URL(baseUrl, path + "?" + cacheQuery).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not get cached asset url template for prebid cache service", e);
        }
    }

    private static URL getCacheBaseUrl(String cacheSchema, String cacheHost) throws MalformedURLException {
        return new URL(cacheSchema + "://" + cacheHost);
    }

    private void updateCreativeMetrics(String accountId, List<CachedCreative> cachedCreatives) {
        for (CachedCreative cachedCreative : cachedCreatives) {
            this.metrics.updateCacheCreativeSize(accountId, cachedCreative.getSize(), CacheService.resolveCreativeTypeName(cachedCreative.getPayload()));
        }
    }

    private static MetricName resolveCreativeTypeName(PutObject putObject) {
        String typeValue = ObjectUtil.getIfNotNull(putObject, PutObject::getType);
        if (Objects.equals(typeValue, XML_CREATIVE_TYPE)) {
            return MetricName.xml;
        }
        if (Objects.equals(typeValue, JSON_CREATIVE_TYPE)) {
            return MetricName.json;
        }
        return MetricName.unknown;
    }

    private static int creativeSizeFromAdm(String adm) {
        return CacheService.lengthOrZero(adm);
    }

    private static int lengthOrZero(String adm) {
        return adm != null ? adm.length() : 0;
    }

    private static int creativeSizeFromTextNode(JsonNode node) {
        return node != null ? node.asText().length() : 0;
    }

    private BidCacheRequest toBidCacheRequest(List<CachedCreative> cachedCreatives) {
        return BidCacheRequest.of(cachedCreatives.stream().map(CachedCreative::getPayload).toList());
    }

    private static final class CachedCreative {
        private final PutObject payload;
        private final int size;

        @ConstructorProperties(value={"payload", "size"})
        private CachedCreative(PutObject payload, int size) {
            this.payload = payload;
            this.size = size;
        }

        public static CachedCreative of(PutObject payload, int size) {
            return new CachedCreative(payload, size);
        }

        public PutObject getPayload() {
            return this.payload;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedCreative)) {
                return false;
            }
            CachedCreative other = (CachedCreative)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            PutObject this$payload = this.getPayload();
            PutObject other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            PutObject $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
            return result;
        }

        public String toString() {
            return "CacheService.CachedCreative(payload=" + this.getPayload() + ", size=" + this.getSize() + ")";
        }
    }
}

