/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yieldone;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.yieldone.ExtImpYieldone;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class YieldoneBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpYieldone>> YIELDONE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpYieldone>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public YieldoneBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                this.validateImpExt(imp);
                Imp updatedImp = this.modifyImp(imp);
                validImps.add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        BidRequest outgoingRequest = request.toBuilder().imp(validImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper)), errors);
    }

    private Imp modifyImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner != null && banner.getH() == null && banner.getW() == null && CollectionUtils.isNotEmpty(banner.getFormat())) {
            Format firstFormat = banner.getFormat().get(0);
            Banner modifiedBanner = banner.toBuilder().h(firstFormat.getH()).w(firstFormat.getW()).build();
            return imp.toBuilder().banner(modifiedBanner).build();
        }
        return imp;
    }

    private void validateImpExt(Imp imp) {
        try {
            this.mapper.mapper().convertValue((Object)imp.getExt(), YIELDONE_EXT_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.decodeBodyToBidResponse(httpCall);
            if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
                return Result.empty();
            }
            List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, YieldoneBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
            return Result.withValues(bidderBids);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() == null) continue;
            return BidType.video;
        }
        throw new PreBidException("Unknown impression type with id " + impId);
    }
}

