/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yeahmobi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.yeahmobi.ExtImpYeahmobi;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class YeahmobiBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpYeahmobi>> EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpYeahmobi>>(){};
    private static final String HOST_MACRO = "{{Host}}";
    private static final String HOST_PATTERN = "gw-%s-bid.yeahtargeter.com";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public YeahmobiBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ExtImpYeahmobi extImp = null;
        for (Imp imp : request.getImp()) {
            try {
                extImp = this.parseImpExt(imp);
                modifiedImps.add(this.modifyImp(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (extImp == null) {
            return Result.withError(BidderError.badInput("Invalid ExtImpYeahmobi value"));
        }
        BidRequest modifiedRequest = request.toBuilder().imp(modifiedImps).build();
        HttpRequest<BidRequest> httpRequest = this.makeHttpRequest(modifiedRequest, extImp.getZoneId());
        return Result.of(Collections.singletonList(httpRequest), errors);
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request, String zoneId) {
        String host = HOST_PATTERN.formatted(zoneId);
        String uri = this.endpointUrl.replace(HOST_MACRO, host);
        return HttpRequest.builder().method(HttpMethod.POST).uri(uri).impIds(BidderUtil.impIds(request)).headers(HttpUtil.headers()).payload(request).body(this.mapper.encodeToBytes(request)).build();
    }

    private ExtImpYeahmobi parseImpExt(Imp imp) {
        try {
            return (ExtImpYeahmobi)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(String.format("Impression id=%s, has invalid Ext", imp.getId()));
        }
    }

    private Imp modifyImp(Imp imp) {
        Native impNative = imp.getXNative();
        return Optional.ofNullable(impNative).map(xNative -> this.resolveNativeRequest(xNative.getRequest())).map(nativeRequest -> imp.toBuilder().xNative((Native)((Native.NativeBuilder)impNative.toBuilder().request((String)nativeRequest)).build()).build()).orElse(imp);
    }

    private String resolveNativeRequest(String nativeRequest) {
        try {
            ObjectNode nativePayload = nativeRequest != null ? (JsonNode)this.mapper.mapper().readValue(nativeRequest, JsonNode.class) : this.mapper.mapper().createObjectNode();
            ObjectNode objectNode = (ObjectNode)this.mapper.mapper().createObjectNode().set("native", (JsonNode)nativePayload);
            return this.mapper.mapper().writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, BidderUtil.getBidType(bid, impMap), bidResponse.getCur())).toList();
    }
}

