/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.videobyte;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.videobyte.ExtImpVideobyte;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class VideobyteBidder
implements Bidder<BidRequest> {
    private static final String DEFAULT_CURRENCY = "USD";
    private static final TypeReference<ExtPrebid<?, ExtImpVideobyte>> VIDEOBYTE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpVideobyte>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public VideobyteBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpVideobyte extImpVideobyte = this.parseImpExt(imp);
                requests.add(this.createRequest(request, imp, extImpVideobyte));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpVideobyte parseImpExt(Imp imp) {
        try {
            return (ExtImpVideobyte)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), VIDEOBYTE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Ignoring imp id=%s, error while decoding, err: %s".formatted(imp.getId(), e.getMessage()));
        }
    }

    private HttpRequest<BidRequest> createRequest(BidRequest bidRequest, Imp imp, ExtImpVideobyte extImpVideobyte) {
        BidRequest modifiedBidRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.createUri(extImpVideobyte)).headers(VideobyteBidder.headers(modifiedBidRequest)).body(this.mapper.encodeToBytes(modifiedBidRequest)).payload(modifiedBidRequest).build();
    }

    private String createUri(ExtImpVideobyte extImpVideobyte) {
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException(e.getMessage());
        }
        uriBuilder.addParameter("source", "pbs").addParameter("pid", extImpVideobyte.getPublisherId());
        VideobyteBidder.addUriParameterIfNotEmpty(uriBuilder, "placementId", extImpVideobyte.getPlacementId());
        VideobyteBidder.addUriParameterIfNotEmpty(uriBuilder, "nid", extImpVideobyte.getNetworkId());
        return uriBuilder.toString();
    }

    private static void addUriParameterIfNotEmpty(URIBuilder uriBuilder, String parameter, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            uriBuilder.addParameter(parameter, value);
        }
    }

    private static MultiMap headers(BidRequest bidRequest) {
        MultiMap headers = HttpUtil.headers();
        Site site = bidRequest.getSite();
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ORIGIN_HEADER, site.getDomain());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, site.getRef());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(VideobyteBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse("Bad server response."));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, VideobyteBidder.resolveBidType(bid.getImpid(), bidRequest.getImp()), DEFAULT_CURRENCY)).toList();
    }

    private static BidType resolveBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!Objects.equals(impId, imp.getId())) continue;
            return imp.getBanner() != null ? BidType.banner : BidType.video;
        }
        return BidType.video;
    }
}

