/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.teads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.http.HttpMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.teads.TeadsImpExtKV;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.teads.TeadsImpExt;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidMeta;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class TeadsBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, TeadsImpExt>> TYPE_REFERENCE = new TypeReference<ExtPrebid<?, TeadsImpExt>>(){};
    private static final TypeReference<ExtPrebid<ExtBidPrebid, ObjectNode>> EXT_PREBID_TYPE_REFERENCE = new TypeReference<ExtPrebid<ExtBidPrebid, ObjectNode>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public TeadsBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        try {
            List<Imp> modifiedImps = request.getImp().stream().map(this::modifyImp).collect(Collectors.toList());
            HttpRequest<BidRequest> httpRequest = this.makeHttpRequest(request.toBuilder().imp(modifiedImps).build());
            return Result.withValue(httpRequest);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
    }

    private Imp modifyImp(Imp imp) {
        TeadsImpExt impExt = this.parseImpExt(imp);
        if (Objects.equals(impExt.getPlacementId(), 0)) {
            throw new PreBidException("placementId should not be 0");
        }
        ObjectNode modifiedImpExt = (ObjectNode)this.mapper.mapper().convertValue((Object)TeadsImpExtKV.of(impExt), ObjectNode.class);
        return imp.toBuilder().tagid(String.valueOf(impExt.getPlacementId())).banner(TeadsBidder.modifyBanner(imp.getBanner())).ext(modifiedImpExt).build();
    }

    private static Banner modifyBanner(Banner banner) {
        List<Format> format;
        if (banner != null && CollectionUtils.isNotEmpty(format = banner.getFormat())) {
            Format firstFormat = format.get(0);
            return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private TeadsImpExt parseImpExt(Imp imp) {
        try {
            return (TeadsImpExt)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(HttpUtil.headers()).impIds(BidderUtil.impIds(bidRequest)).body(this.mapper.encodeToBytes(bidRequest)).payload(bidRequest).build();
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse("Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().flatMap(seatBid -> Optional.ofNullable(seatBid.getBid()).orElse(List.of()).stream()).map(bid -> this.makeBid(impMap, (Bid)bid, bidResponse.getCur())).toList();
    }

    private BidderBid makeBid(Map<String, Imp> impMap, Bid bid, String currency) {
        BidType bidType = Optional.ofNullable(impMap.get(bid.getImpid())).map(imp -> imp.getVideo() == null ? BidType.banner : BidType.video).orElseThrow(() -> new PreBidException("Bid for the Imp " + bid.getImpid() + " wasn't found"));
        ExtBidPrebid prebid = this.parseExtBidPrebidMeta(bid);
        ExtBidPrebidMeta meta = prebid.getMeta();
        if (StringUtils.isBlank((CharSequence)meta.getRendererName())) {
            throw new PreBidException("RendererName should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)meta.getRendererVersion())) {
            throw new PreBidException("RendererVersion should not be empty");
        }
        ExtBidPrebidMeta modifiedMeta = ExtBidPrebidMeta.builder().rendererName(meta.getRendererName()).rendererVersion(meta.getRendererVersion()).build();
        ExtBidPrebid modifiedPrebid = prebid.toBuilder().meta(modifiedMeta).build();
        ObjectNode modifiedBidExt = (ObjectNode)this.mapper.mapper().valueToTree(ExtPrebid.of(modifiedPrebid, null));
        return BidderBid.of(bid.toBuilder().ext(modifiedBidExt).build(), bidType, currency);
    }

    private ExtBidPrebid parseExtBidPrebidMeta(Bid bid) {
        try {
            return (ExtBidPrebid)((ExtPrebid)this.mapper.mapper().convertValue((Object)bid.getExt(), EXT_PREBID_TYPE_REFERENCE)).getPrebid();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

