/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.sovrn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.sovrn.ExtImpSovrn;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class SovrnBidder
implements Bidder<BidRequest> {
    private static final String LJT_READER_COOKIE_NAME = "ljt_reader";
    private static final String EXT_AD_UNIT_CODE_PARAM = "adunitcode";
    private static final TypeReference<ExtPrebid<?, ExtImpSovrn>> SOVRN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpSovrn>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public SovrnBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> processedImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                SovrnBidder.validateImpVideo(imp.getVideo());
                processedImps.add(this.makeImp(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(processedImps).build();
        return this.makeHttpRequest(outgoingRequest, errors);
    }

    private static void validateImpVideo(Video video) {
        if (video != null && (video.getMimes() == null || BidderUtil.isNullOrZero(video.getMaxduration()) || video.getProtocols() == null)) {
            throw new PreBidException("Missing required video parameter");
        }
    }

    private Imp makeImp(Imp imp) {
        ObjectNode impExt = imp.getExt();
        ExtImpSovrn sovrnExt = this.parseExtImpSovrn(impExt);
        return imp.toBuilder().bidfloor(SovrnBidder.resolveBidFloor(imp.getBidfloor(), sovrnExt.getBidfloor())).tagid(this.resolveTagId(sovrnExt)).ext(this.resolveImpExt(sovrnExt, impExt)).build();
    }

    private ExtImpSovrn parseExtImpSovrn(ObjectNode ext) {
        try {
            return (ExtImpSovrn)((ExtPrebid)this.mapper.mapper().convertValue((Object)ext, SOVRN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static BigDecimal resolveBidFloor(BigDecimal impBidFloor, BigDecimal extBidFloor) {
        return !BidderUtil.isValidPrice(impBidFloor) && BidderUtil.isValidPrice(extBidFloor) ? extBidFloor : impBidFloor;
    }

    private String resolveTagId(ExtImpSovrn sovrnExt) {
        String tagId = (String)ObjectUtils.defaultIfNull((Object)sovrnExt.getTagid(), (Object)sovrnExt.getLegacyTagId());
        if (StringUtils.isEmpty((CharSequence)tagId)) {
            throw new PreBidException("Missing required parameter 'tagid'");
        }
        return tagId;
    }

    private ObjectNode resolveImpExt(ExtImpSovrn sovrnExt, ObjectNode impExt) {
        ObjectNode sovrnImpExt = impExt.deepCopy();
        return StringUtils.isNotBlank((CharSequence)sovrnExt.getAdunitcode()) ? sovrnImpExt.putPOJO(EXT_AD_UNIT_CODE_PARAM, (Object)sovrnExt.getAdunitcode()) : sovrnImpExt;
    }

    private Result<List<HttpRequest<BidRequest>>> makeHttpRequest(BidRequest bidRequest, List<BidderError> errors) {
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes(bidRequest)).headers(SovrnBidder.headers(bidRequest)).payload(bidRequest).build()), errors);
    }

    private static MultiMap headers(BidRequest bidRequest) {
        User user;
        String buyeruid;
        MultiMap headers = HttpUtil.headers();
        Device device = bidRequest.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.DNT_HEADER, Objects.toString(device.getDnt(), null));
        }
        String string = buyeruid = (user = bidRequest.getUser()) != null ? StringUtils.trimToNull((String)user.getBuyeruid()) : null;
        if (buyeruid != null) {
            headers.add(HttpUtil.COOKIE_HEADER, (CharSequence)Cookie.cookie((String)LJT_READER_COOKIE_NAME, (String)buyeruid).encode());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> bidderErrors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            BidRequest request = httpCall.getRequest().getPayload();
            return Result.of(SovrnBidder.extractBids(bidResponse, request, bidderErrors), bidderErrors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest, List<BidderError> bidderErrors) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : SovrnBidder.bidsFromResponse(bidResponse, bidRequest, bidderErrors);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, BidRequest bidRequest, List<BidderError> bidderErrors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> SovrnBidder.makeBidderBid(bid, SovrnBidder.resolveBidType(bid.getImpid(), bidRequest.getImp(), bidderErrors), bidResponse.getCur())).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, BidType bidType, String cur) {
        if (bidType == null) {
            return null;
        }
        Bid updatedBid = bid.toBuilder().adm(HttpUtil.decodeUrl(bid.getAdm())).build();
        return BidderBid.of(updatedBid, bidType, cur);
    }

    private static BidType resolveBidType(String impId, List<Imp> imps, List<BidderError> bidderErrors) {
        for (Imp imp : imps) {
            boolean matchedImpId = impId.equals(imp.getId());
            if (matchedImpId && imp.getVideo() != null) {
                return BidType.video;
            }
            if (!matchedImpId) continue;
            return BidType.banner;
        }
        bidderErrors.add(BidderError.badInput("Imp ID " + impId + " in bid didn't match with any imp in the original request"));
        return null;
    }
}

