/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.richaudience;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.richaudience.ExtImpRichaudience;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class RichaudienceBidder
implements Bidder<BidRequest> {
    private static final int BID_TEST_REQUEST = 1;
    private static final String OPENRTB_VERSION = "2.5";
    private static final String DEVICE_IP = "11.222.33.44";
    private static final String DEFAULT_CURRENCY = "USD";
    private static final String HTTPS = "https";
    private static final String TAG_ID_KEY = "tagId";
    private static final TypeReference<ExtPrebid<?, ExtImpRichaudience>> RICHAUDIENCE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpRichaudience>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public RichaudienceBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            RichaudienceBidder.validateRequest(request);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        for (Imp imp : request.getImp()) {
            try {
                RichaudienceBidder.validateImp(imp);
                ExtImpRichaudience extImp = this.parseImpExt(imp);
                BidRequest modifiedBidRequest = RichaudienceBidder.makeRequest(request, imp, extImp);
                httpRequests.add(this.makeHttpRequest(modifiedBidRequest, Collections.singleton(imp.getId())));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return httpRequests.isEmpty() ? Result.withErrors(errors) : Result.of(httpRequests, errors);
    }

    private static void validateRequest(BidRequest bidRequest) throws PreBidException {
        Device device = bidRequest.getDevice();
        if (device == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{device.getIp(), device.getIpv6()})) {
            throw new PreBidException("Device IP is required.");
        }
    }

    private static void validateImp(Imp imp) throws PreBidException {
        if (imp.getBanner() != null && !RichaudienceBidder.isBannerSizesPresent(imp.getBanner())) {
            throw new PreBidException("Banner W/H/Format is required. ImpId: " + imp.getId());
        }
        if (imp.getVideo() != null && !RichaudienceBidder.isVideoSizesPresent(imp.getVideo())) {
            throw new PreBidException("Video W and H are required. ImpId: " + imp.getId());
        }
    }

    private static boolean isBannerSizesPresent(Banner banner) {
        return ObjectUtils.anyNotNull((Object[])new Object[]{banner.getW(), banner.getH()}) || CollectionUtils.isNotEmpty(banner.getFormat());
    }

    private static boolean isVideoSizesPresent(Video video) {
        return video.getW() != null && video.getW() != 0 && video.getH() != null && video.getH() != 0;
    }

    private ExtImpRichaudience parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpRichaudience)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), RICHAUDIENCE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Invalid ext. Imp.Id: " + imp.getId());
        }
    }

    private static BidRequest makeRequest(BidRequest request, Imp imp, ExtImpRichaudience extImp) {
        Site originalSite = request.getSite();
        Optional<URL> urlOptional = RichaudienceBidder.extractUrl(originalSite);
        boolean isSecure = urlOptional.map(URL::getProtocol).map(HTTPS::equals).orElse(false);
        Imp modifiedImp = RichaudienceBidder.modifyImp(imp, extImp, isSecure);
        Site modifiedSite = urlOptional.map(url -> RichaudienceBidder.modifySite(originalSite, imp.getTagid(), url)).orElseGet(() -> RichaudienceBidder.modifySite(originalSite, imp.getTagid()));
        App modifiedApp = RichaudienceBidder.modifyApp(request.getApp(), imp.getTagid());
        boolean isTest = BooleanUtils.isTrue((Boolean)extImp.getTest());
        return request.toBuilder().imp(Collections.singletonList(modifiedImp)).site(modifiedSite).app(modifiedApp).test(isTest ? Integer.valueOf(1) : null).device(isTest ? request.getDevice().toBuilder().ip(DEVICE_IP).build() : request.getDevice()).build();
    }

    private static Site modifySite(Site originalSite, String tagId, URL url) {
        return originalSite.toBuilder().keywords("tagId=" + tagId).domain(StringUtils.isBlank((CharSequence)originalSite.getDomain()) ? url.getHost() : originalSite.getDomain()).build();
    }

    private static Site modifySite(Site originalSite, String tagId) {
        return Optional.ofNullable(originalSite).map(site -> site.toBuilder().keywords("tagId=" + tagId).build()).orElse(originalSite);
    }

    private static App modifyApp(App originalApp, String tagId) {
        return Optional.ofNullable(originalApp).map(app -> app.toBuilder().keywords("tagId=" + tagId).build()).orElse(originalApp);
    }

    private static Optional<URL> extractUrl(Site site) {
        return Optional.ofNullable(site).map(Site::getPage).map(page -> {
            try {
                return new URL((String)page);
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
    }

    private static Imp modifyImp(Imp imp, ExtImpRichaudience extImp, boolean isSecure) {
        String tagId = extImp.getPid();
        String extBidFloorCur = extImp.getBidFloorCur();
        String impBidFloorCur = imp.getBidfloorcur();
        String bidFloorCur = (String)StringUtils.defaultIfBlank((CharSequence)extBidFloorCur, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)impBidFloorCur, (CharSequence)DEFAULT_CURRENCY)));
        return imp.toBuilder().secure(BooleanUtils.toInteger((boolean)isSecure)).tagid((String)StringUtils.defaultIfBlank((CharSequence)tagId, (CharSequence)imp.getTagid())).bidfloorcur(bidFloorCur).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, Set<String> impIds) {
        return HttpRequest.builder().method(HttpMethod.POST).headers(this.resolveHeaders()).impIds(impIds).uri(this.endpointUrl).body(this.mapper.encodeToBytes(bidRequest)).payload(bidRequest).build();
    }

    private MultiMap resolveHeaders() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)OPENRTB_VERSION);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(bidResponse, bidRequest));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).flatMap(seatBid -> seatBid.getBid().stream()).filter(Objects::nonNull).filter(bid -> impMap.containsKey(bid.getImpid())).map(bid -> RichaudienceBidder.makeBid(bidResponse, impMap, bid)).toList();
    }

    private static BidderBid makeBid(BidResponse bidResponse, Map<String, Imp> impMap, Bid bid) {
        Imp imp = impMap.get(bid.getImpid());
        BidType bidType = RichaudienceBidder.resolveBidType(imp);
        Bid.BidBuilder builder = bid.toBuilder();
        if (bidType == BidType.video) {
            builder.w(imp.getVideo().getW());
            builder.h(imp.getVideo().getH());
        }
        return BidderBid.of(builder.build(), bidType, bidResponse.getCur());
    }

    private static BidType resolveBidType(Imp imp) {
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        return BidType.banner;
    }
}

