/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.outbrain;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.EventTracker;
import com.iab.openrtb.response.Response;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.outbrains.ExtImpOutbrain;
import org.prebid.server.proto.openrtb.ext.request.outbrains.ExtImpOutbrainPublisher;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class OutbrainBidder
implements Bidder<BidRequest> {
    private static final int IMAGE_TRACKER_METHOD = 1;
    private static final int JS_TRACKER_METHOD = 2;
    private static final int EVENT_TYPE_IMPRESSION = 1;
    private static final TypeReference<ExtPrebid<?, ExtImpOutbrain>> OUTBRAIN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpOutbrain>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public OutbrainBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ExtImpOutbrain extImpOutbrain = null;
        for (Imp imp : request.getImp()) {
            try {
                extImpOutbrain = this.parseImpExt(imp);
                modifiedImps.add(OutbrainBidder.modifyImp(imp, extImpOutbrain.getTagid()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest updatedRequest = OutbrainBidder.updateBidRequest(request, modifiedImps, extImpOutbrain);
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(updatedRequest, this.endpointUrl, this.mapper)), errors);
    }

    private ExtImpOutbrain parseImpExt(Imp imp) {
        try {
            return (ExtImpOutbrain)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), OUTBRAIN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Impression id=%s, has invalid Ext".formatted(imp.getId()));
        }
    }

    private static Imp modifyImp(Imp imp, String tagId) {
        return StringUtils.isNotEmpty((CharSequence)tagId) ? imp.toBuilder().tagid(tagId).build() : imp;
    }

    private static BidRequest updateBidRequest(BidRequest bidRequest, List<Imp> imps, ExtImpOutbrain extImpOutbrain) {
        List<String> badv;
        BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder();
        Publisher publisher = OutbrainBidder.createPublisher(extImpOutbrain.getPublisher());
        Site site = bidRequest.getSite();
        App app = bidRequest.getApp();
        if (site != null) {
            bidRequestBuilder.site(OutbrainBidder.updateSite(site, publisher));
        } else if (app != null) {
            bidRequestBuilder.app(OutbrainBidder.updateApp(app, publisher));
        }
        List<String> bcat = extImpOutbrain.getBcat();
        if (CollectionUtils.isNotEmpty(bcat)) {
            bidRequestBuilder.bcat(bcat);
        }
        if (CollectionUtils.isNotEmpty(badv = extImpOutbrain.getBadv())) {
            bidRequestBuilder.badv(badv);
        }
        return bidRequestBuilder.imp(imps).build();
    }

    private static Publisher createPublisher(ExtImpOutbrainPublisher extImpPublisher) {
        return Publisher.builder().id(extImpPublisher.getId()).name(extImpPublisher.getName()).domain(extImpPublisher.getDomain()).build();
    }

    private static Site updateSite(Site site, Publisher publisher) {
        return site.toBuilder().publisher(publisher).build();
    }

    private static App updateApp(App app, Publisher publisher) {
        return app.toBuilder().publisher(publisher).build();
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.createBidderBid((Bid)bid, bidRequest.getImp(), bidResponse.getCur(), errors)).toList();
    }

    private BidderBid createBidderBid(Bid bid, List<Imp> requestImps, String cur, List<BidderError> errors) {
        BidType bidType = OutbrainBidder.getBidType(bid.getImpid(), requestImps);
        return BidderBid.of(this.updateBid(bid, bidType, errors), bidType, cur);
    }

    private Bid updateBid(Bid bid, BidType bidType, List<BidderError> errors) {
        String bidAdm = bid.getAdm();
        String resolvedAdm = bidType.equals((Object)BidType.xNative) && StringUtils.isNotEmpty((CharSequence)bidAdm) ? this.resolveBidAdm(bidAdm, errors) : null;
        return resolvedAdm != null ? bid.toBuilder().adm(resolvedAdm).build() : bid;
    }

    private String resolveBidAdm(String adm, List<BidderError> errors) {
        Response response;
        try {
            response = this.mapper.decodeValue(adm, Response.class);
        }
        catch (DecodeException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        List<EventTracker> eventtrackers = response.getEventtrackers();
        if (CollectionUtils.isEmpty(eventtrackers)) {
            return null;
        }
        List imptrackers = ListUtils.defaultIfNull(response.getImptrackers(), new ArrayList());
        String jstracker = response.getJstracker();
        for (EventTracker eventTracker : eventtrackers) {
            if (!Objects.equals(eventTracker.getEvent(), 1)) continue;
            Integer currentMethod = eventTracker.getMethod();
            if (Objects.equals(currentMethod, 1)) {
                imptrackers.add(eventTracker.getUrl());
                continue;
            }
            if (!Objects.equals(currentMethod, 2)) continue;
            jstracker = "<script src=\"%s\"></script>".formatted(eventTracker.getUrl());
        }
        return this.mapper.encodeToString(response.toBuilder().eventtrackers(null).jstracker(jstracker).imptrackers(imptrackers).build());
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getBanner() == null) continue;
            return BidType.banner;
        }
        throw new PreBidException("Failed to find native/banner impression \"%s\"".formatted(impId));
    }
}

