/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;

public final class BidderError {
    private final String message;
    private final Type type;
    private final Set<String> impIds;

    public static BidderError of(String message, Type type) {
        return BidderError.of(message, type, Collections.emptySet());
    }

    public static BidderError create(String message, Type type) {
        return BidderError.of(message, type);
    }

    public static BidderError generic(String message) {
        return BidderError.of(message, Type.generic);
    }

    public static BidderError invalidBid(String message) {
        return BidderError.of(message, Type.invalid_bid);
    }

    public static BidderError badInput(String message) {
        return BidderError.of(message, Type.bad_input);
    }

    public static BidderError badServerResponse(String message) {
        return BidderError.of(message, Type.bad_server_response);
    }

    public static BidderError rejectedIpf(String message, String impId) {
        return BidderError.of(message, Type.rejected_ipf, Collections.singleton(impId));
    }

    public static BidderError failedToRequestBids(String message) {
        return BidderError.of(message, Type.failed_to_request_bids);
    }

    public static BidderError timeout(String message) {
        return BidderError.of(message, Type.timeout);
    }

    @ConstructorProperties(value={"message", "type", "impIds"})
    private BidderError(String message, Type type, Set<String> impIds) {
        this.message = message;
        this.type = type;
        this.impIds = impIds;
    }

    public static BidderError of(String message, Type type, Set<String> impIds) {
        return new BidderError(message, type, impIds);
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> getImpIds() {
        return this.impIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderError)) {
            return false;
        }
        BidderError other = (BidderError)o;
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Set<String> this$impIds = this.getImpIds();
        Set<String> other$impIds = other.getImpIds();
        return !(this$impIds == null ? other$impIds != null : !((Object)this$impIds).equals(other$impIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Set<String> $impIds = this.getImpIds();
        result = result * 59 + ($impIds == null ? 43 : ((Object)$impIds).hashCode());
        return result;
    }

    public String toString() {
        return "BidderError(message=" + this.getMessage() + ", type=" + this.getType() + ", impIds=" + this.getImpIds() + ")";
    }

    public static enum Type {
        bad_input(2),
        bad_server_response(3),
        failed_to_request_bids(4),
        invalid_bid(5),
        rejected_ipf(6),
        timeout(1),
        generic(999);

        private final Integer code;

        private Type(Integer errorCode) {
            this.code = errorCode;
        }

        public Integer getCode() {
            return this.code;
        }
    }
}

