/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.ix;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.ntv.EventTrackingMethod;
import com.iab.openrtb.request.ntv.EventType;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.EventTracker;
import com.iab.openrtb.response.Response;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.ix.model.request.IxDiag;
import org.prebid.server.bidder.ix.model.response.NativeV11Wrapper;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.proto.openrtb.ext.request.ix.ExtImpIx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.version.PrebidVersionProvider;

public class IxBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpIx>> IX_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpIx>>(){};
    private final String endpointUrl;
    private final PrebidVersionProvider prebidVersionProvider;
    private final JacksonMapper mapper;

    public IxBidder(String endpointUrl, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        HashSet<String> siteIds = new HashSet<String>();
        ArrayList<Imp> imps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpIx impExt = this.parseImpExt(imp);
                String siteId = impExt.getSiteId();
                if (StringUtils.isNotEmpty((CharSequence)siteId)) {
                    siteIds.add(siteId);
                }
                imps.add(this.modifyImp(imp, impExt));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (imps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest modifiedBidRequest = this.modifyBidRequest(bidRequest, imps, siteIds);
        List<HttpRequest<BidRequest>> httpRequests = Collections.singletonList(BidderUtil.defaultRequest(modifiedBidRequest, this.endpointUrl, this.mapper));
        return Result.of(httpRequests, errors);
    }

    private ExtImpIx parseImpExt(Imp imp) {
        try {
            return (ExtImpIx)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), IX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, ExtImpIx impExt) {
        UpdateResult<ObjectNode> impExtUpdateResult = this.modifyImpExt(imp, impExt);
        UpdateResult<Banner> bannerUpdateResult = this.modifyImpBanner(imp.getBanner());
        return impExtUpdateResult.isUpdated() || bannerUpdateResult.isUpdated() ? imp.toBuilder().ext(impExtUpdateResult.getValue()).banner(bannerUpdateResult.getValue()).build() : imp;
    }

    private UpdateResult<ObjectNode> modifyImpExt(Imp imp, ExtImpIx extImpIx) {
        String sid = extImpIx.getSid();
        ObjectNode impExt = imp.getExt();
        if (StringUtils.isEmpty((CharSequence)sid)) {
            return UpdateResult.unaltered(impExt);
        }
        ObjectNode updatedExt = impExt.deepCopy();
        updatedExt.set("sid", (JsonNode)TextNode.valueOf((String)sid));
        return UpdateResult.updated(updatedExt);
    }

    private UpdateResult<Banner> modifyImpBanner(Banner banner) {
        if (banner == null) {
            return UpdateResult.unaltered(null);
        }
        List<Format> formats = banner.getFormat();
        Integer w = banner.getW();
        Integer h = banner.getH();
        if (CollectionUtils.isEmpty(formats) && h != null && w != null) {
            List<Format> newFormats = Collections.singletonList(Format.builder().w(w).h(h).build());
            Banner modifiedBanner = banner.toBuilder().format(newFormats).build();
            return UpdateResult.updated(modifiedBanner);
        }
        if (formats.size() == 1) {
            Format format = formats.get(0);
            Banner modifiedBanner = banner.toBuilder().w(format.getW()).h(format.getH()).build();
            return UpdateResult.updated(modifiedBanner);
        }
        return UpdateResult.unaltered(banner);
    }

    private BidRequest modifyBidRequest(BidRequest bidRequest, List<Imp> imps, Set<String> siteIds) {
        String publisherId = Optional.of(siteIds).filter(siteIdsSet -> siteIdsSet.size() == 1).map(Collection::stream).flatMap(Stream::findFirst).orElse(null);
        return bidRequest.toBuilder().imp(imps).site(IxBidder.modifySite(bidRequest.getSite(), publisherId)).app(IxBidder.modifyApp(bidRequest.getApp(), publisherId)).ext(this.modifyRequestExt(bidRequest.getExt(), siteIds)).build();
    }

    private ExtRequest modifyRequestExt(ExtRequest extRequest, Set<String> siteIds) {
        ExtRequest modifiedExt;
        if (extRequest != null) {
            modifiedExt = ExtRequest.of(extRequest.getPrebid());
            modifiedExt.addProperties(extRequest.getProperties());
        } else {
            modifiedExt = ExtRequest.empty();
        }
        modifiedExt.addProperty("ixdiag", this.mapper.mapper().valueToTree((Object)this.makeDiagData(extRequest, siteIds)));
        return modifiedExt;
    }

    private IxDiag makeDiagData(ExtRequest extRequest, Set<String> siteIds) {
        String pbjsv = Optional.ofNullable(extRequest).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getChannel).map(ExtRequestPrebidChannel::getVersion).orElse(null);
        String pbsv = this.prebidVersionProvider.getNameVersionRecord();
        String multipleSiteIds = siteIds.size() > 1 ? siteIds.stream().sorted().collect(Collectors.joining(", ")) : null;
        return IxDiag.of(pbsv, pbjsv, multipleSiteIds);
    }

    private static Site modifySite(Site site, String id) {
        return Optional.ofNullable(site).map(Site::toBuilder).map(builder -> builder.publisher(IxBidder.modifyPublisher(site.getPublisher(), id))).map(Site.SiteBuilder::build).orElse(null);
    }

    private static App modifyApp(App app, String id) {
        return Optional.ofNullable(app).map(App::toBuilder).map(builder -> builder.publisher(IxBidder.modifyPublisher(app.getPublisher(), id))).map(App.AppBuilder::build).orElse(null);
    }

    private static Publisher modifyPublisher(Publisher publisher, String id) {
        return Optional.ofNullable(publisher).map(Publisher::toBuilder).orElseGet(Publisher::builder).id(id).build();
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> errors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            BidRequest payload = httpCall.getRequest().getPayload();
            return Result.of(this.extractBids(bidResponse, payload, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest, List<BidderError> errors) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse, bidRequest, errors);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse, BidRequest bidRequest, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.toBidderBid((Bid)bid, bidRequest, bidResponse, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid toBidderBid(Bid bid, BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = IxBidder.getBidType(bid, bidRequest.getImp());
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        Bid updatedBid = switch (bidType) {
            case BidType.video -> this.updateBidWithVideoAttributes(bid);
            case BidType.xNative -> bid.toBuilder().adm(this.updateBidAdmWithNativeAttributes(bid.getAdm())).build();
            default -> bid;
        };
        return BidderBid.of(updatedBid, bidType, bidResponse.getCur());
    }

    private Bid updateBidWithVideoAttributes(Bid bid) {
        Bid updatedBid;
        ExtBidPrebidVideo extVideo;
        ObjectNode bidExt = bid.getExt();
        ExtBidPrebid extPrebid = bidExt != null ? this.parseBidExt(bidExt) : null;
        ExtBidPrebidVideo extBidPrebidVideo = extVideo = extPrebid != null ? extPrebid.getVideo() : null;
        if (extVideo != null) {
            Bid.BidBuilder bidBuilder = bid.toBuilder();
            bidBuilder.ext(this.resolveBidExt(extVideo.getDuration()));
            if (CollectionUtils.isEmpty(bid.getCat())) {
                bidBuilder.cat(Collections.singletonList(extVideo.getPrimaryCategory())).build();
            }
            updatedBid = bidBuilder.build();
        } else {
            updatedBid = bid;
        }
        return updatedBid;
    }

    private String updateBidAdmWithNativeAttributes(String adm) {
        NativeV11Wrapper nativeV11 = this.parseBidAdm(adm, NativeV11Wrapper.class);
        Response responseV11 = ObjectUtil.getIfNotNull(nativeV11, NativeV11Wrapper::getNativeResponse);
        boolean isV11 = responseV11 != null;
        Response response = isV11 ? responseV11 : this.parseBidAdm(adm, Response.class);
        List trackers = ObjectUtil.getIfNotNull(response, Response::getEventtrackers);
        String updatedAdm = CollectionUtils.isNotEmpty((Collection)trackers) ? this.mapper.encodeToString(isV11 ? NativeV11Wrapper.of(IxBidder.mergeNativeImpTrackers(response, trackers)) : IxBidder.mergeNativeImpTrackers(response, trackers)) : null;
        return updatedAdm != null ? updatedAdm : adm;
    }

    private <T> T parseBidAdm(String adm, Class<T> clazz) {
        try {
            return this.mapper.decodeValue(adm, clazz);
        }
        catch (IllegalArgumentException | DecodeException e) {
            return null;
        }
    }

    private static Response mergeNativeImpTrackers(Response response, List<EventTracker> eventTrackers) {
        List<EventTracker> impressionAndImageTrackers = eventTrackers.stream().filter(tracker -> Objects.equals(tracker.getMethod(), EventType.IMPRESSION.getValue()) || Objects.equals(tracker.getEvent(), EventTrackingMethod.IMAGE.getValue())).toList();
        List<String> impTrackers = Stream.concat(impressionAndImageTrackers.stream().map(EventTracker::getUrl), response.getImptrackers().stream()).distinct().toList();
        return response.toBuilder().imptrackers(impTrackers).build();
    }

    private static BidType getBidType(Bid bid, List<Imp> imps) {
        return IxBidder.getBidTypeFromMtype(bid.getMtype()).or(() -> IxBidder.getBidTypeFromExtPrebidType(bid.getExt())).orElseGet(() -> IxBidder.getBidTypeFromImp(imps, bid.getImpid()));
    }

    private static Optional<BidType> getBidTypeFromMtype(Integer mType) {
        BidType bidType;
        if (mType != null) {
            switch (mType) {
                case 1: {
                    bidType = BidType.banner;
                    break;
                }
                case 2: {
                    bidType = BidType.video;
                    break;
                }
                case 3: {
                    bidType = BidType.audio;
                    break;
                }
                case 4: {
                    bidType = BidType.xNative;
                    break;
                }
                default: {
                    bidType = null;
                    break;
                }
            }
        } else {
            bidType = null;
        }
        BidType bidType2 = bidType;
        return Optional.ofNullable(bidType2);
    }

    private static Optional<BidType> getBidTypeFromExtPrebidType(ObjectNode bidExt) {
        return Optional.ofNullable(bidExt).map(ext -> ext.get("prebid")).map(prebid -> prebid.get("type")).map(JsonNode::asText).map(BidType::fromString);
    }

    private static BidType getBidTypeFromImp(List<Imp> imps, String impId) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        throw new PreBidException("Unmatched impression id " + impId);
    }

    private ExtBidPrebid parseBidExt(ObjectNode bidExt) {
        try {
            return (ExtBidPrebid)this.mapper.mapper().treeToValue((TreeNode)bidExt, ExtBidPrebid.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private ObjectNode resolveBidExt(Integer duration) {
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtBidPrebid.builder().video(ExtBidPrebidVideo.of(duration, null)).build());
    }
}

