/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.invibes.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.prebid.server.bidder.invibes.model.InvibesPlacementProperty;

public final class InvibesBidParams {
    @JsonProperty(value="PlacementIds")
    private final List<String> placementIds;
    @JsonProperty(value="BidVersion")
    private final String bidVersion;
    @JsonProperty(value="Properties")
    private final Map<String, InvibesPlacementProperty> properties;

    @ConstructorProperties(value={"placementIds", "bidVersion", "properties"})
    InvibesBidParams(List<String> placementIds, String bidVersion, Map<String, InvibesPlacementProperty> properties) {
        this.placementIds = placementIds;
        this.bidVersion = bidVersion;
        this.properties = properties;
    }

    public static InvibesBidParamsBuilder builder() {
        return new InvibesBidParamsBuilder();
    }

    public InvibesBidParamsBuilder toBuilder() {
        return new InvibesBidParamsBuilder().placementIds(this.placementIds).bidVersion(this.bidVersion).properties(this.properties);
    }

    public List<String> getPlacementIds() {
        return this.placementIds;
    }

    public String getBidVersion() {
        return this.bidVersion;
    }

    public Map<String, InvibesPlacementProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvibesBidParams)) {
            return false;
        }
        InvibesBidParams other = (InvibesBidParams)o;
        List<String> this$placementIds = this.getPlacementIds();
        List<String> other$placementIds = other.getPlacementIds();
        if (this$placementIds == null ? other$placementIds != null : !((Object)this$placementIds).equals(other$placementIds)) {
            return false;
        }
        String this$bidVersion = this.getBidVersion();
        String other$bidVersion = other.getBidVersion();
        if (this$bidVersion == null ? other$bidVersion != null : !this$bidVersion.equals(other$bidVersion)) {
            return false;
        }
        Map<String, InvibesPlacementProperty> this$properties = this.getProperties();
        Map<String, InvibesPlacementProperty> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $placementIds = this.getPlacementIds();
        result = result * 59 + ($placementIds == null ? 43 : ((Object)$placementIds).hashCode());
        String $bidVersion = this.getBidVersion();
        result = result * 59 + ($bidVersion == null ? 43 : $bidVersion.hashCode());
        Map<String, InvibesPlacementProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "InvibesBidParams(placementIds=" + this.getPlacementIds() + ", bidVersion=" + this.getBidVersion() + ", properties=" + this.getProperties() + ")";
    }

    public static class InvibesBidParamsBuilder {
        private List<String> placementIds;
        private String bidVersion;
        private Map<String, InvibesPlacementProperty> properties;

        InvibesBidParamsBuilder() {
        }

        @JsonProperty(value="PlacementIds")
        public InvibesBidParamsBuilder placementIds(List<String> placementIds) {
            this.placementIds = placementIds;
            return this;
        }

        @JsonProperty(value="BidVersion")
        public InvibesBidParamsBuilder bidVersion(String bidVersion) {
            this.bidVersion = bidVersion;
            return this;
        }

        @JsonProperty(value="Properties")
        public InvibesBidParamsBuilder properties(Map<String, InvibesPlacementProperty> properties) {
            this.properties = properties;
            return this;
        }

        public InvibesBidParams build() {
            return new InvibesBidParams(this.placementIds, this.bidVersion, this.properties);
        }

        public String toString() {
            return "InvibesBidParams.InvibesBidParamsBuilder(placementIds=" + this.placementIds + ", bidVersion=" + this.bidVersion + ", properties=" + this.properties + ")";
        }
    }
}

