/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.improvedigital;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.improvedigital.proto.ImprovedigitalBidExt;
import org.prebid.server.bidder.improvedigital.proto.ImprovedigitalBidExtImprovedigital;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ConsentedProvidersSettings;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.improvedigital.ExtImpImprovedigital;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class ImprovedigitalBidder
implements Bidder<BidRequest> {
    private static final String URL_PATH_PREFIX_MACRO = "{{PathPrefix}}";
    private static final TypeReference<ExtPrebid<?, ExtImpImprovedigital>> IMPROVEDIGITAL_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpImprovedigital>>(){};
    private static final String CONSENT_PROVIDERS_SETTINGS_OUT_KEY = "consented_providers_settings";
    private static final String CONSENTED_PROVIDERS_KEY = "consented_providers";
    private static final String REGEX_SPLIT_STRING_BY_DOT = "\\.";
    private static final String IS_REWARDED_INVENTORY_FIELD = "is_rewarded_inventory";
    private static final JsonPointer IS_REWARDED_INVENTORY_POINTER = JsonPointer.valueOf((String)"/prebid/is_rewarded_inventory");
    private static final Pattern DEALS_PATTERN = Pattern.compile("(classic|deal)");
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ImprovedigitalBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpImprovedigital extImp = this.parseImpExt(imp);
                httpRequests.add(this.resolveRequest(request, imp, extImp.getPublisherId()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            return Result.withErrors(errors);
        }
        return Result.withValues(httpRequests);
    }

    private ExtUser getAdditionalConsentProvidersUserExt(ExtUser extUser) {
        String consentedProviders = ObjectUtil.getIfNotNull(ObjectUtil.getIfNotNull(extUser, ExtUser::getConsentedProvidersSettings), ConsentedProvidersSettings::getConsentedProviders);
        if (StringUtils.isBlank((CharSequence)consentedProviders)) {
            return extUser;
        }
        String consentedProvidersPart = StringUtils.substringAfter((String)consentedProviders, (String)"~");
        if (StringUtils.isEmpty((CharSequence)consentedProvidersPart)) {
            return extUser;
        }
        return this.fillExtUser(extUser, consentedProvidersPart.split(REGEX_SPLIT_STRING_BY_DOT));
    }

    private ExtUser fillExtUser(ExtUser extUser, String[] arrayOfSplitString) {
        JsonNode consentProviderSettingJsonNode;
        try {
            consentProviderSettingJsonNode = this.customJsonNode(arrayOfSplitString);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        return this.mapper.fillExtension(extUser, consentProviderSettingJsonNode);
    }

    private JsonNode customJsonNode(String[] arrayOfSplitString) {
        Integer[] integers = (Integer[])this.mapper.mapper().convertValue((Object)arrayOfSplitString, Integer[].class);
        ArrayNode arrayNode = this.mapper.mapper().createArrayNode();
        for (Integer integer : integers) {
            arrayNode.add(integer);
        }
        return this.mapper.mapper().createObjectNode().set(CONSENT_PROVIDERS_SETTINGS_OUT_KEY, this.mapper.mapper().createObjectNode().set(CONSENTED_PROVIDERS_KEY, (JsonNode)arrayNode));
    }

    private ExtImpImprovedigital parseImpExt(Imp imp) {
        try {
            return (ExtImpImprovedigital)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), IMPROVEDIGITAL_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static Imp updateImp(Imp imp) {
        ObjectNode modifiedExt = imp.getExt().deepCopy();
        JsonNode rewardedNode = modifiedExt.at(IS_REWARDED_INVENTORY_POINTER);
        if (!rewardedNode.isMissingNode() && rewardedNode.asInt() == 1) {
            modifiedExt.put(IS_REWARDED_INVENTORY_FIELD, true);
        }
        return imp.toBuilder().ext(modifiedExt).build();
    }

    private HttpRequest<BidRequest> resolveRequest(BidRequest bidRequest, Imp imp, Integer publisherId) {
        User user = bidRequest.getUser();
        BidRequest modifiedRequest = bidRequest.toBuilder().imp(Collections.singletonList(ImprovedigitalBidder.updateImp(imp))).user(user != null ? user.toBuilder().ext(this.getAdditionalConsentProvidersUserExt(user.getExt())).build() : null).build();
        String pathPrefix = publisherId != null && publisherId > 0 ? String.format("%d/", publisherId) : "";
        String endpointUrl = this.endpointUrl.replace(URL_PATH_PREFIX_MACRO, pathPrefix);
        return BidderUtil.defaultRequest(modifiedRequest, endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        if (bidResponse.getSeatbid().size() > 1) {
            throw new PreBidException("Unexpected SeatBid! Must be only one but have: %d".formatted(bidResponse.getSeatbid().size()));
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.createBidderBid((Bid)bid, impMap, bidResponse.getCur())).filter(Objects::nonNull).toList();
    }

    private BidderBid createBidderBid(Bid bid, Map<String, Imp> impMap, String cur) {
        Imp imp = impMap.get(bid.getImpid());
        if (imp == null) {
            throw new PreBidException("Failed to find impression for ID: \"%s\"".formatted(bid.getImpid()));
        }
        Bid resolvedBid = this.resolveBid(bid, imp);
        return BidderBid.of(resolvedBid, ImprovedigitalBidder.getBidType(resolvedBid), cur);
    }

    private Bid resolveBid(Bid bid, Imp imp) {
        Integer mtype = bid.getMtype();
        if (mtype == null && ImprovedigitalBidder.isMultiFormat(imp)) {
            throw new PreBidException("Bid must have non-null mtype for multi format impression with ID: \"%s\"".formatted(imp.getId()));
        }
        return bid.toBuilder().mtype(mtype != null ? mtype : ImprovedigitalBidder.resolveMtypeFromImp(imp)).dealid(this.resolveDealId(bid)).build();
    }

    private String resolveDealId(Bid bid) {
        ImprovedigitalBidExtImprovedigital bidExtImprovedigital = this.parseBidExtImprovedigital(bid);
        String buyingType = bidExtImprovedigital != null ? bidExtImprovedigital.getBuyingType() : null;
        Integer lineItemId = bidExtImprovedigital != null ? bidExtImprovedigital.getLineItemId() : null;
        return lineItemId != null && StringUtils.isNotBlank((CharSequence)buyingType) && DEALS_PATTERN.matcher(buyingType).matches() ? lineItemId.toString() : bid.getDealid();
    }

    private ImprovedigitalBidExtImprovedigital parseBidExtImprovedigital(Bid bid) {
        ObjectNode bidExt = bid.getExt();
        try {
            return bidExt != null ? ((ImprovedigitalBidExt)this.mapper.mapper().treeToValue((TreeNode)bidExt, ImprovedigitalBidExt.class)).getImprovedigital() : null;
        }
        catch (JsonProcessingException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static BidType getBidType(Bid bid) {
        return switch (bid.getMtype()) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            case 3 -> BidType.audio;
            case 4 -> BidType.xNative;
            default -> throw new PreBidException("Unsupported mtype %d for impression with ID: \"%s\"".formatted(bid.getMtype(), bid.getImpid()));
        };
    }

    private static int resolveMtypeFromImp(Imp imp) {
        if (imp.getBanner() != null) {
            return 1;
        }
        if (imp.getVideo() != null) {
            return 2;
        }
        if (imp.getAudio() != null) {
            return 3;
        }
        if (imp.getXNative() != null) {
            return 4;
        }
        throw new PreBidException("Could not determine bid type for impression with ID: \"%s\"".formatted(imp.getId()));
    }

    private static boolean isMultiFormat(Imp imp) {
        int formatCount = 0;
        formatCount += imp.getBanner() == null ? 0 : 1;
        formatCount += imp.getVideo() == null ? 0 : 1;
        formatCount += imp.getAudio() == null ? 0 : 1;
        return (formatCount += imp.getXNative() == null ? 0 : 1) > 1;
    }
}

