/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.conversant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.conversant.ExtImpConversant;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class ConversantBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpConversant>> CONVERSANT_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpConversant>>(){};
    private static final Set<Integer> APIS = IntStream.range(1, 7).boxed().collect(Collectors.toSet());
    private static final Set<Integer> PROTOCOLS = IntStream.range(1, 11).boxed().collect(Collectors.toSet());
    private static final Set<Integer> AD_POSITIONS = IntStream.range(0, 8).boxed().collect(Collectors.toSet());
    private static final String DISPLAY_MANAGER = "prebid-s2s";
    private static final String DISPLAY_MANAGER_VER = "2.0.0";
    private final String endpointUrl;
    private final boolean generateBidId;
    private final JacksonMapper mapper;

    public ConversantBidder(String endpointUrl, boolean generateBidId, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.generateBidId = generateBidId;
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        BidRequest outgoingRequest;
        try {
            outgoingRequest = this.createOutgoingRequest(bidRequest);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper)), Collections.emptyList());
    }

    private BidRequest createOutgoingRequest(BidRequest bidRequest) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        List<Imp> requestImps = bidRequest.getImp();
        for (int i = 0; i < requestImps.size(); ++i) {
            Imp imp = requestImps.get(i);
            ExtImpConversant impExt = this.parseImpExt(imp, i);
            modifiedImps.add(ConversantBidder.modifyImp(imp, impExt));
        }
        Imp firstImp = requestImps.get(0);
        ExtImpConversant extImp = this.parseImpExt(firstImp, 0);
        String siteId = extImp.getSiteId();
        Site requestSite = bidRequest.getSite();
        App requestApp = bidRequest.getApp();
        return bidRequest.toBuilder().site(ConversantBidder.updateSite(requestSite, siteId)).app(requestSite == null ? ConversantBidder.updateApp(requestApp, siteId) : requestApp).imp(modifiedImps).build();
    }

    private ExtImpConversant parseImpExt(Imp imp, int impIndex) {
        ExtImpConversant extImp;
        try {
            extImp = (ExtImpConversant)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), CONVERSANT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Impression[%d] missing ext.bidder object".formatted(impIndex));
        }
        if (StringUtils.isEmpty((CharSequence)extImp.getSiteId())) {
            throw new PreBidException("Impression[%d] requires ext.bidder.site_id".formatted(impIndex));
        }
        return extImp;
    }

    private static Site updateSite(Site site, String siteId) {
        return site == null ? null : site.toBuilder().id(siteId).build();
    }

    private static App updateApp(App app, String siteId) {
        return app == null ? null : app.toBuilder().id(siteId).build();
    }

    private static Imp modifyImp(Imp imp, ExtImpConversant impExt) {
        Banner banner = imp.getBanner();
        Video video = imp.getVideo();
        return imp.toBuilder().displaymanager(DISPLAY_MANAGER).displaymanagerver(DISPLAY_MANAGER_VER).bidfloor(ConversantBidder.getBidFloor(imp.getBidfloor(), impExt.getBidfloor())).tagid(ConversantBidder.getTagId(imp.getTagid(), impExt.getTagId())).secure(ConversantBidder.getSecure(imp, impExt)).banner(ConversantBidder.modifyBanner(banner, impExt.getPosition())).video(video != null && banner == null ? ConversantBidder.modifyVideo(video, impExt) : video).build();
    }

    private static String getTagId(String tagId, String impExtTagId) {
        return StringUtils.isNotEmpty((CharSequence)impExtTagId) ? impExtTagId : tagId;
    }

    private static BigDecimal getBidFloor(BigDecimal impBidFloor, BigDecimal impExtBidFloor) {
        return BidderUtil.isValidPrice(impExtBidFloor) && !BidderUtil.isValidPrice(impBidFloor) ? impExtBidFloor : impBidFloor;
    }

    private static Integer getSecure(Imp imp, ExtImpConversant impExt) {
        Integer extSecure = impExt.getSecure();
        Integer impSecure = imp.getSecure();
        return extSecure != null && BidderUtil.isNullOrZero(impSecure) ? extSecure : impSecure;
    }

    private static Banner modifyBanner(Banner impBanner, Integer extPosition) {
        return impBanner == null ? null : impBanner.toBuilder().pos(ConversantBidder.isValidPosition(extPosition) ? extPosition : null).build();
    }

    private static Video modifyVideo(Video video, ExtImpConversant impExt) {
        List<String> extMimes = impExt.getMimes();
        Integer extMaxDuration = impExt.getMaxduration();
        Integer extPosition = impExt.getPosition();
        return video.toBuilder().mimes(CollectionUtils.isNotEmpty(extMimes) ? extMimes : video.getMimes()).maxduration(extMaxDuration != null ? extMaxDuration : video.getMaxduration()).pos(ConversantBidder.isValidPosition(extPosition) ? extPosition : null).api(ConversantBidder.makeApi(impExt.getApi(), video.getApi())).protocols(ConversantBidder.makeProtocols(impExt.getProtocols(), video.getProtocols())).build();
    }

    private static boolean isValidPosition(Integer position) {
        return position != null && AD_POSITIONS.contains(position);
    }

    private static List<Integer> makeApi(List<Integer> extApi, List<Integer> videoApi) {
        List<Integer> api;
        List<Integer> list = api = CollectionUtils.isNotEmpty(extApi) ? extApi : videoApi;
        return CollectionUtils.isNotEmpty(api) ? api.stream().filter(APIS::contains).toList() : videoApi;
    }

    private static List<Integer> makeProtocols(List<Integer> extProtocols, List<Integer> videoProtocols) {
        List<Integer> protocols;
        List<Integer> list = protocols = CollectionUtils.isNotEmpty(extProtocols) ? extProtocols : videoProtocols;
        return CollectionUtils.isNotEmpty(protocols) ? protocols.stream().filter(PROTOCOLS::contains).toList() : videoProtocols;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            return Result.withValues(this.extractBids(httpCall));
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidderCall<BidRequest> httpCall) {
        BidResponse bidResponse;
        try {
            bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage());
        }
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            throw new PreBidException("Empty bid request");
        }
        return this.bidsFromResponse(httpCall.getRequest().getPayload(), bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        SeatBid firstSeatBid = bidResponse.getSeatbid().get(0);
        List<Bid> bids = firstSeatBid.getBid();
        if (CollectionUtils.isEmpty(bids)) {
            throw new PreBidException("Empty bids array");
        }
        return bids.stream().filter(Objects::nonNull).map(bid -> BidderBid.of(this.updateBidWithId((Bid)bid), ConversantBidder.getType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private Bid updateBidWithId(Bid bid) {
        return this.generateBidId ? bid.toBuilder().id(UUID.randomUUID().toString()).build() : bid;
    }

    private static BidType getType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        return BidType.banner;
    }
}

