/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bidmyadz;

import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class BidmyadzBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BidmyadzBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        if (!BidmyadzBidder.isValidRequest(request, errors)) {
            return Result.withErrors(errors);
        }
        return Result.withValue(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(BidmyadzBidder.createHeaders()).payload(request).body(this.mapper.encodeToBytes(request)).build());
    }

    private static boolean isValidRequest(BidRequest request, List<BidderError> errors) {
        String userAgent;
        String ipv6;
        Device device;
        if (request.getImp().size() > 1) {
            errors.add(BidderError.badInput("Bidder does not support multi impression"));
        }
        String ip = (device = request.getDevice()) != null ? device.getIp() : null;
        String string = ipv6 = device != null ? device.getIpv6() : null;
        if (StringUtils.isEmpty((CharSequence)ip) && StringUtils.isEmpty((CharSequence)ipv6)) {
            errors.add(BidderError.badInput("IP/IPv6 is a required field"));
        }
        String string2 = userAgent = device != null ? device.getUa() : null;
        if (StringUtils.isEmpty((CharSequence)userAgent)) {
            errors.add(BidderError.badInput("User-Agent is a required field"));
        }
        return errors.isEmpty();
    }

    private static MultiMap createHeaders() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValue(this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private BidderBid extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid");
        }
        return this.bidsFromResponse(bidResponse);
    }

    private BidderBid bidsFromResponse(BidResponse bidResponse) {
        List<Bid> bids = bidResponse.getSeatbid().get(0).getBid();
        if (CollectionUtils.isEmpty(bids)) {
            throw new PreBidException("Empty SeatBid.Bids");
        }
        Bid bid = bids.get(0);
        return BidderBid.of(bid, BidmyadzBidder.getBidType((JsonNode)bid.getExt()), bidResponse.getCur());
    }

    private static BidType getBidType(JsonNode ext) {
        String mediaType;
        JsonNode mediaTypeNode = ext != null ? ext.get("mediaType") : null;
        String string = mediaType = mediaTypeNode != null && mediaTypeNode.isTextual() ? mediaTypeNode.asText() : null;
        if (StringUtils.isEmpty(mediaType)) {
            throw new PreBidException("Missed mediaType");
        }
        try {
            return BidType.valueOf(mediaType);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

