/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.between;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.between.ExtImpBetween;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class BetweenBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpBetween>> BETWEEN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpBetween>>(){};
    private static final String URL_HOST_MACRO = "{{Host}}";
    private static final String PUBLISHER_ID_MACRO = "{{PublisherId}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final boolean endpointContainsHostMacro;

    public BetweenBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.endpointContainsHostMacro = endpointUrl.contains(URL_HOST_MACRO);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        Integer secure = BetweenBidder.resolveSecure(request.getSite());
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ExtImpBetween extImpBetween = null;
        for (Imp imp : request.getImp()) {
            try {
                extImpBetween = this.parseImpExt(imp);
                this.validateImp(imp, extImpBetween);
                modifiedImps.add(BetweenBidder.modifyImp(imp, secure));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            return Result.withErrors(errors);
        }
        return Result.withValue(this.createRequest(extImpBetween, request, modifiedImps));
    }

    private static Integer resolveSecure(Site site) {
        return site != null && StringUtils.isNotBlank((CharSequence)site.getPage()) && site.getPage().startsWith("https") ? 1 : 0;
    }

    private void validateImp(Imp imp, ExtImpBetween extImp) {
        Banner banner = imp.getBanner();
        if (imp.getBanner() == null) {
            throw new PreBidException("Request needs to include a Banner object");
        }
        if (banner.getW() == null && banner.getH() == null && CollectionUtils.isEmpty(banner.getFormat())) {
            throw new PreBidException("Need at least one size to build request");
        }
        String missingParamErrorMessage = "required BetweenSSP parameter %s is missing in impression with id: %s";
        if (StringUtils.isBlank((CharSequence)extImp.getPublisherId())) {
            throw new PreBidException("required BetweenSSP parameter %s is missing in impression with id: %s".formatted("publisher_id", imp.getId()));
        }
        if (this.endpointContainsHostMacro && StringUtils.isBlank((CharSequence)extImp.getHost())) {
            throw new PreBidException("required BetweenSSP parameter %s is missing in impression with id: %s".formatted("host", imp.getId()));
        }
    }

    private ExtImpBetween parseImpExt(Imp imp) {
        ExtImpBetween extImpBetween;
        try {
            extImpBetween = (ExtImpBetween)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BETWEEN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + imp.getId());
        }
        return extImpBetween;
    }

    private static Imp modifyImp(Imp imp, Integer secure) {
        Banner resolvedBanner = BetweenBidder.resolveBanner(imp.getBanner());
        return imp.toBuilder().banner(resolvedBanner).secure(secure).build();
    }

    private static Banner resolveBanner(Banner banner) {
        if (banner.getW() == null && banner.getH() == null) {
            List<Format> bannerFormat = banner.getFormat();
            Format firstFormat = bannerFormat.get(0);
            List<Format> formatSkipFirst = bannerFormat.subList(1, bannerFormat.size());
            return banner.toBuilder().format(formatSkipFirst).w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private HttpRequest<BidRequest> createRequest(ExtImpBetween extImpBetween, BidRequest request, List<Imp> imps) {
        String url = this.endpointUrl.replace(URL_HOST_MACRO, StringUtils.defaultString((String)extImpBetween.getHost())).replace(PUBLISHER_ID_MACRO, HttpUtil.encodeUrl(extImpBetween.getPublisherId()));
        BidRequest outgoingRequest = request.toBuilder().imp(imps).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(BetweenBidder.resolveHeaders(request.getDevice(), request.getSite())).impIds(BidderUtil.impIds(outgoingRequest)).payload(outgoingRequest).body(this.mapper.encodeToBytes(outgoingRequest)).build();
    }

    private static MultiMap resolveHeaders(Device device, Site site) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            Integer dnt = device.getDnt();
            if (dnt != null) {
                headers.add(HttpUtil.DNT_HEADER, (CharSequence)dnt.toString());
            }
        }
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, site.getPage());
        }
        return headers;
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(BetweenBidder.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return BetweenBidder.bidsFromResponse(bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, BidType.banner, bidResponse.getCur())).toList();
    }
}

