/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.beintoo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.beintoo.ExtImpBeintoo;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class BeintooBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpBeintoo>> BEINTOO_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpBeintoo>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BeintooBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest updatedBidRequest;
        try {
            updatedBidRequest = this.updateBidRequest(request);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        MultiMap headers = BeintooBidder.makeHeaders(request);
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes(updatedBidRequest)).headers(headers).payload(request).build()), Collections.emptyList());
    }

    private BidRequest updateBidRequest(BidRequest request) {
        boolean isSecure = BeintooBidder.isSecure(request.getSite());
        List<Imp> modifiedImps = request.getImp().stream().map(imp -> BeintooBidder.modifyImp(imp, isSecure, this.parseAndValidateImpExt((Imp)imp))).toList();
        return request.toBuilder().imp(modifiedImps).build();
    }

    private static boolean isSecure(Site site) {
        return site != null && StringUtils.isNotBlank((CharSequence)site.getPage()) && site.getPage().startsWith("https");
    }

    private ExtImpBeintoo parseAndValidateImpExt(Imp imp) {
        ExtImpBeintoo extImpBeintoo;
        try {
            extImpBeintoo = (ExtImpBeintoo)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BEINTOO_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
        String tagId = extImpBeintoo.getTagId();
        if (!StringUtils.isNumeric((CharSequence)tagId)) {
            throw new PreBidException("tagid must be a String of numbers, ignoring imp id=" + imp.getId());
        }
        int tagidNumber = Integer.parseInt(tagId);
        if (tagidNumber == 0) {
            throw new PreBidException("tagid cant be 0, ignoring imp id=" + imp.getId());
        }
        return extImpBeintoo;
    }

    private static Imp modifyImp(Imp imp, boolean isSecure, ExtImpBeintoo extImpBeintoo) {
        Banner banner = BeintooBidder.modifyImpBanner(imp.getBanner());
        Imp.ImpBuilder impBuilder = imp.toBuilder().tagid(extImpBeintoo.getTagId()).secure(BooleanUtils.toInteger((boolean)isSecure)).banner(banner).ext(null);
        String stringBidfloor = extImpBeintoo.getBidFloor();
        BigDecimal bidfloor = StringUtils.isBlank((CharSequence)stringBidfloor) ? null : new BigDecimal(stringBidfloor);
        return BidderUtil.isValidPrice(bidfloor) ? impBuilder.bidfloor(bidfloor).build() : impBuilder.build();
    }

    private static Banner modifyImpBanner(Banner banner) {
        if (banner == null) {
            throw new PreBidException("Request needs to include a Banner object");
        }
        if (banner.getW() == null && banner.getH() == null) {
            Banner.BannerBuilder bannerBuilder = banner.toBuilder();
            List<Format> originalFormat = banner.getFormat();
            if (CollectionUtils.isEmpty(originalFormat)) {
                throw new PreBidException("Need at least one size to build request");
            }
            List<Format> formatSkipFirst = originalFormat.subList(1, originalFormat.size());
            bannerBuilder.format(formatSkipFirst);
            Format firstFormat = originalFormat.get(0);
            bannerBuilder.w(firstFormat.getW());
            bannerBuilder.h(firstFormat.getH());
            return bannerBuilder.build();
        }
        return banner;
    }

    private static MultiMap makeHeaders(BidRequest request) {
        Site site;
        MultiMap headers = HttpUtil.headers();
        Device device = request.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.DNT_HEADER, Objects.toString(device.getDnt(), null));
        }
        if ((site = request.getSite()) != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, site.getPage());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(BeintooBidder.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : BeintooBidder.bidsFromResponse(bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> bid.toBuilder().impid(bid.getId()).build()).map(bid -> BidderBid.of(bid, BidType.banner, bidResponse.getCur())).toList();
    }
}

