/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adhese;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adhese.model.AdheseOriginData;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adhese.ExtImpAdhese;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AdheseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdhese>> ADHESE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdhese>>(){};
    private static final String SLOT_PARAMETER = "SL";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdheseBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpAdhese extImpAdhese;
        if (CollectionUtils.isEmpty(request.getImp())) {
            return Result.withError(BidderError.badInput("No impression in the bid request"));
        }
        try {
            extImpAdhese = this.parseImpExt(request.getImp().get(0));
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        String uri = this.getUrl(extImpAdhese);
        BidRequest modifiedBidRequest = this.modifyBidRequest(request, extImpAdhese);
        return Result.withValue(BidderUtil.defaultRequest(modifiedBidRequest, uri, this.mapper));
    }

    private ExtImpAdhese parseImpExt(Imp imp) {
        try {
            return (ExtImpAdhese)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADHESE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private String getUrl(ExtImpAdhese extImpAdhese) {
        return this.endpointUrl.replace("{{AccountId}}", extImpAdhese.getAccount());
    }

    private BidRequest modifyBidRequest(BidRequest bidRequest, ExtImpAdhese extImpAdhese) {
        TreeMap<String, List<String>> parameterMap = new TreeMap<String, List<String>>();
        parameterMap.putAll(this.getTargetParameters(extImpAdhese));
        parameterMap.putAll(AdheseBidder.getSlotParameter(extImpAdhese));
        ObjectNode adheseExtInnerNode = (ObjectNode)this.mapper.mapper().valueToTree(parameterMap);
        ObjectNode adheseExtNode = (ObjectNode)this.mapper.mapper().createObjectNode().set("adhese", (JsonNode)adheseExtInnerNode);
        Imp imp = bidRequest.getImp().get(0).toBuilder().ext(adheseExtNode).build();
        return bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
    }

    private Map<String, List<String>> getTargetParameters(ExtImpAdhese extImpAdhese) {
        JsonNode targets = extImpAdhese.getTargets();
        return targets == null || targets.isEmpty() ? Collections.emptyMap() : this.parseTargetParametersAndSort(targets);
    }

    private Map<String, List<String>> parseTargetParametersAndSort(JsonNode targets) {
        return new TreeMap<String, List<String>>((Map)this.mapper.mapper().convertValue((Object)targets, (TypeReference)new TypeReference<Map<String, List<String>>>(){}));
    }

    private static Map<String, List<String>> getSlotParameter(ExtImpAdhese extImpAdhese) {
        String slot = "%s-%s".formatted(HttpUtil.encodeUrl(extImpAdhese.getLocation()), HttpUtil.encodeUrl(extImpAdhese.getFormat()));
        return Collections.singletonMap(SLOT_PARAMETER, Collections.singletonList(slot));
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            Optional<Bid> optionalBid = AdheseBidder.getBid(bidResponse);
            if (optionalBid.isEmpty()) {
                return Result.empty();
            }
            Bid bid = optionalBid.get();
            AdheseOriginData originData = this.toObjectOfType(bid.getExt().get("adhese"), AdheseOriginData.class);
            Bid modifiedBid = bid.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)originData)).build();
            BidderBid bidderBid = BidderBid.of(modifiedBid, AdheseBidder.getBidType(bidRequest), bidResponse.getCur());
            return Result.of(Collections.singletonList(bidderBid), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static Optional<Bid> getBid(BidResponse bidResponse) {
        return Optional.ofNullable(bidResponse).map(BidResponse::getSeatbid).stream().flatMap(Collection::stream).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).findFirst();
    }

    private <T> T toObjectOfType(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)this.mapper.mapper().treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static BidType getBidType(BidRequest bidRequest) {
        List<Imp> impList = bidRequest.getImp();
        if (impList == null || impList.isEmpty()) {
            throw new PreBidException("No Imps available");
        }
        Imp firstImp = impList.get(0);
        if (firstImp.getBanner() != null) {
            return BidType.banner;
        }
        if (firstImp.getVideo() != null) {
            return BidType.video;
        }
        if (firstImp.getXNative() != null) {
            return BidType.xNative;
        }
        if (firstImp.getAudio() != null) {
            return BidType.audio;
        }
        throw new PreBidException("Failed to obtain BidType");
    }
}

