/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.spring.config.bidder.model.CompressionType;
import org.prebid.server.spring.config.bidder.model.MediaType;

public final class BidderInfo {
    private final boolean enabled;
    private final OrtbVersion ortbVersion;
    private final boolean debugAllowed;
    private final boolean usesHttps;
    private final String aliasOf;
    private final MaintainerInfo maintainer;
    private final CapabilitiesInfo capabilities;
    private final List<String> vendors;
    private final GdprInfo gdpr;
    private final boolean ccpaEnforced;
    private final boolean modifyingVastXmlAllowed;
    private final CompressionType compressionType;

    public static BidderInfo create(boolean enabled, OrtbVersion ortbVersion, boolean debugAllowed, String endpoint, String aliasOf, String maintainerEmail, List<MediaType> appMediaTypes, List<MediaType> siteMediaTypes, List<MediaType> doohMediaTypes, List<String> supportedVendors, int vendorId, boolean ccpaEnforced, boolean modifyingVastXmlAllowed, CompressionType compressionType) {
        return BidderInfo.of(enabled, ortbVersion, debugAllowed, StringUtils.startsWith((CharSequence)endpoint, (CharSequence)"https://"), aliasOf, new MaintainerInfo(maintainerEmail), new CapabilitiesInfo(BidderInfo.platformInfo(appMediaTypes), BidderInfo.platformInfo(siteMediaTypes), BidderInfo.platformInfo(doohMediaTypes)), supportedVendors, new GdprInfo(vendorId), ccpaEnforced, modifyingVastXmlAllowed, compressionType);
    }

    private static PlatformInfo platformInfo(List<MediaType> mediaTypes) {
        return mediaTypes != null ? new PlatformInfo(mediaTypes) : null;
    }

    @ConstructorProperties(value={"enabled", "ortbVersion", "debugAllowed", "usesHttps", "aliasOf", "maintainer", "capabilities", "vendors", "gdpr", "ccpaEnforced", "modifyingVastXmlAllowed", "compressionType"})
    private BidderInfo(boolean enabled, OrtbVersion ortbVersion, boolean debugAllowed, boolean usesHttps, String aliasOf, MaintainerInfo maintainer, CapabilitiesInfo capabilities, List<String> vendors, GdprInfo gdpr, boolean ccpaEnforced, boolean modifyingVastXmlAllowed, CompressionType compressionType) {
        this.enabled = enabled;
        this.ortbVersion = ortbVersion;
        this.debugAllowed = debugAllowed;
        this.usesHttps = usesHttps;
        this.aliasOf = aliasOf;
        this.maintainer = maintainer;
        this.capabilities = capabilities;
        this.vendors = vendors;
        this.gdpr = gdpr;
        this.ccpaEnforced = ccpaEnforced;
        this.modifyingVastXmlAllowed = modifyingVastXmlAllowed;
        this.compressionType = compressionType;
    }

    public static BidderInfo of(boolean enabled, OrtbVersion ortbVersion, boolean debugAllowed, boolean usesHttps, String aliasOf, MaintainerInfo maintainer, CapabilitiesInfo capabilities, List<String> vendors, GdprInfo gdpr, boolean ccpaEnforced, boolean modifyingVastXmlAllowed, CompressionType compressionType) {
        return new BidderInfo(enabled, ortbVersion, debugAllowed, usesHttps, aliasOf, maintainer, capabilities, vendors, gdpr, ccpaEnforced, modifyingVastXmlAllowed, compressionType);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public OrtbVersion getOrtbVersion() {
        return this.ortbVersion;
    }

    public boolean isDebugAllowed() {
        return this.debugAllowed;
    }

    public boolean isUsesHttps() {
        return this.usesHttps;
    }

    public String getAliasOf() {
        return this.aliasOf;
    }

    public MaintainerInfo getMaintainer() {
        return this.maintainer;
    }

    public CapabilitiesInfo getCapabilities() {
        return this.capabilities;
    }

    public List<String> getVendors() {
        return this.vendors;
    }

    public GdprInfo getGdpr() {
        return this.gdpr;
    }

    public boolean isCcpaEnforced() {
        return this.ccpaEnforced;
    }

    public boolean isModifyingVastXmlAllowed() {
        return this.modifyingVastXmlAllowed;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderInfo)) {
            return false;
        }
        BidderInfo other = (BidderInfo)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDebugAllowed() != other.isDebugAllowed()) {
            return false;
        }
        if (this.isUsesHttps() != other.isUsesHttps()) {
            return false;
        }
        if (this.isCcpaEnforced() != other.isCcpaEnforced()) {
            return false;
        }
        if (this.isModifyingVastXmlAllowed() != other.isModifyingVastXmlAllowed()) {
            return false;
        }
        OrtbVersion this$ortbVersion = this.getOrtbVersion();
        OrtbVersion other$ortbVersion = other.getOrtbVersion();
        if (this$ortbVersion == null ? other$ortbVersion != null : !((Object)((Object)this$ortbVersion)).equals((Object)other$ortbVersion)) {
            return false;
        }
        String this$aliasOf = this.getAliasOf();
        String other$aliasOf = other.getAliasOf();
        if (this$aliasOf == null ? other$aliasOf != null : !this$aliasOf.equals(other$aliasOf)) {
            return false;
        }
        MaintainerInfo this$maintainer = this.getMaintainer();
        MaintainerInfo other$maintainer = other.getMaintainer();
        if (this$maintainer == null ? other$maintainer != null : !((Object)this$maintainer).equals(other$maintainer)) {
            return false;
        }
        CapabilitiesInfo this$capabilities = this.getCapabilities();
        CapabilitiesInfo other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        List<String> this$vendors = this.getVendors();
        List<String> other$vendors = other.getVendors();
        if (this$vendors == null ? other$vendors != null : !((Object)this$vendors).equals(other$vendors)) {
            return false;
        }
        GdprInfo this$gdpr = this.getGdpr();
        GdprInfo other$gdpr = other.getGdpr();
        if (this$gdpr == null ? other$gdpr != null : !((Object)this$gdpr).equals(other$gdpr)) {
            return false;
        }
        CompressionType this$compressionType = this.getCompressionType();
        CompressionType other$compressionType = other.getCompressionType();
        return !(this$compressionType == null ? other$compressionType != null : !((Object)((Object)this$compressionType)).equals((Object)other$compressionType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDebugAllowed() ? 79 : 97);
        result = result * 59 + (this.isUsesHttps() ? 79 : 97);
        result = result * 59 + (this.isCcpaEnforced() ? 79 : 97);
        result = result * 59 + (this.isModifyingVastXmlAllowed() ? 79 : 97);
        OrtbVersion $ortbVersion = this.getOrtbVersion();
        result = result * 59 + ($ortbVersion == null ? 43 : ((Object)((Object)$ortbVersion)).hashCode());
        String $aliasOf = this.getAliasOf();
        result = result * 59 + ($aliasOf == null ? 43 : $aliasOf.hashCode());
        MaintainerInfo $maintainer = this.getMaintainer();
        result = result * 59 + ($maintainer == null ? 43 : ((Object)$maintainer).hashCode());
        CapabilitiesInfo $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        List<String> $vendors = this.getVendors();
        result = result * 59 + ($vendors == null ? 43 : ((Object)$vendors).hashCode());
        GdprInfo $gdpr = this.getGdpr();
        result = result * 59 + ($gdpr == null ? 43 : ((Object)$gdpr).hashCode());
        CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : ((Object)((Object)$compressionType)).hashCode());
        return result;
    }

    public String toString() {
        return "BidderInfo(enabled=" + this.isEnabled() + ", ortbVersion=" + this.getOrtbVersion() + ", debugAllowed=" + this.isDebugAllowed() + ", usesHttps=" + this.isUsesHttps() + ", aliasOf=" + this.getAliasOf() + ", maintainer=" + this.getMaintainer() + ", capabilities=" + this.getCapabilities() + ", vendors=" + this.getVendors() + ", gdpr=" + this.getGdpr() + ", ccpaEnforced=" + this.isCcpaEnforced() + ", modifyingVastXmlAllowed=" + this.isModifyingVastXmlAllowed() + ", compressionType=" + this.getCompressionType() + ")";
    }

    public static final class MaintainerInfo {
        private final String email;

        @ConstructorProperties(value={"email"})
        public MaintainerInfo(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaintainerInfo)) {
                return false;
            }
            MaintainerInfo other = (MaintainerInfo)o;
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        public String toString() {
            return "BidderInfo.MaintainerInfo(email=" + this.getEmail() + ")";
        }
    }

    public static final class CapabilitiesInfo {
        private final PlatformInfo app;
        private final PlatformInfo site;
        private final PlatformInfo dooh;

        @ConstructorProperties(value={"app", "site", "dooh"})
        public CapabilitiesInfo(PlatformInfo app, PlatformInfo site, PlatformInfo dooh) {
            this.app = app;
            this.site = site;
            this.dooh = dooh;
        }

        public PlatformInfo getApp() {
            return this.app;
        }

        public PlatformInfo getSite() {
            return this.site;
        }

        public PlatformInfo getDooh() {
            return this.dooh;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CapabilitiesInfo)) {
                return false;
            }
            CapabilitiesInfo other = (CapabilitiesInfo)o;
            PlatformInfo this$app = this.getApp();
            PlatformInfo other$app = other.getApp();
            if (this$app == null ? other$app != null : !((Object)this$app).equals(other$app)) {
                return false;
            }
            PlatformInfo this$site = this.getSite();
            PlatformInfo other$site = other.getSite();
            if (this$site == null ? other$site != null : !((Object)this$site).equals(other$site)) {
                return false;
            }
            PlatformInfo this$dooh = this.getDooh();
            PlatformInfo other$dooh = other.getDooh();
            return !(this$dooh == null ? other$dooh != null : !((Object)this$dooh).equals(other$dooh));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PlatformInfo $app = this.getApp();
            result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
            PlatformInfo $site = this.getSite();
            result = result * 59 + ($site == null ? 43 : ((Object)$site).hashCode());
            PlatformInfo $dooh = this.getDooh();
            result = result * 59 + ($dooh == null ? 43 : ((Object)$dooh).hashCode());
            return result;
        }

        public String toString() {
            return "BidderInfo.CapabilitiesInfo(app=" + this.getApp() + ", site=" + this.getSite() + ", dooh=" + this.getDooh() + ")";
        }
    }

    public static final class PlatformInfo {
        @JsonProperty(value="mediaTypes")
        private final List<MediaType> mediaTypes;

        @ConstructorProperties(value={"mediaTypes"})
        public PlatformInfo(List<MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }

        public List<MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlatformInfo)) {
                return false;
            }
            PlatformInfo other = (PlatformInfo)o;
            List<MediaType> this$mediaTypes = this.getMediaTypes();
            List<MediaType> other$mediaTypes = other.getMediaTypes();
            return !(this$mediaTypes == null ? other$mediaTypes != null : !((Object)this$mediaTypes).equals(other$mediaTypes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MediaType> $mediaTypes = this.getMediaTypes();
            result = result * 59 + ($mediaTypes == null ? 43 : ((Object)$mediaTypes).hashCode());
            return result;
        }

        public String toString() {
            return "BidderInfo.PlatformInfo(mediaTypes=" + this.getMediaTypes() + ")";
        }
    }

    public static final class GdprInfo {
        @JsonProperty(value="vendorId")
        private final int vendorId;

        @ConstructorProperties(value={"vendorId"})
        public GdprInfo(int vendorId) {
            this.vendorId = vendorId;
        }

        public int getVendorId() {
            return this.vendorId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GdprInfo)) {
                return false;
            }
            GdprInfo other = (GdprInfo)o;
            return this.getVendorId() == other.getVendorId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVendorId();
            return result;
        }

        public String toString() {
            return "BidderInfo.GdprInfo(vendorId=" + this.getVendorId() + ")";
        }
    }
}

