/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.versionconverter.up;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.User;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConverter;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;

public class BidRequestOrtb25To26Converter
implements BidRequestOrtbVersionConverter {
    private static final String PREBID_FIELD = "prebid";
    private static final String IS_REWARDED_INVENTORY_FIELD = "is_rewarded_inventory";
    private static final JsonPointer IMP_EXT_PREBID_REWARDED = JsonPointer.valueOf((String)"/prebid/is_rewarded_inventory");

    @Override
    public BidRequest convert(BidRequest bidRequest) {
        User user;
        User modifiedUser;
        Regs regs;
        Regs modifiedRegs;
        Source source;
        Source modifiedSource;
        List<Imp> imps = bidRequest.getImp();
        List<Imp> modifiedImps = BidRequestOrtb25To26Converter.moveImpsData(imps);
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedImps, modifiedSource = BidRequestOrtb25To26Converter.moveSourceData(source = bidRequest.getSource()), modifiedRegs = BidRequestOrtb25To26Converter.moveRegsData(regs = bidRequest.getRegs()), modifiedUser = BidRequestOrtb25To26Converter.moveUserData(user = bidRequest.getUser())}) ? bidRequest.toBuilder().imp(modifiedImps != null ? modifiedImps : imps).source(modifiedSource != null ? modifiedSource : source).regs(modifiedRegs != null ? modifiedRegs : regs).user(modifiedUser != null ? modifiedUser : user).build() : bidRequest;
    }

    private static List<Imp> moveImpsData(List<Imp> imps) {
        List<Imp> modifiedImps = CollectionUtils.emptyIfNull(imps).stream().map(BidRequestOrtb25To26Converter::moveImpData).toList();
        if (modifiedImps.stream().allMatch(Objects::isNull)) {
            return null;
        }
        return IntStream.range(0, imps.size()).mapToObj(i -> (Imp)ObjectUtils.defaultIfNull((Object)((Imp)modifiedImps.get(i)), (Object)((Imp)imps.get(i)))).toList();
    }

    private static Imp moveImpData(Imp imp) {
        ObjectNode resolvedExtImp;
        if (imp == null) {
            return null;
        }
        ObjectNode extImp = imp.getExt();
        if (extImp == null) {
            return null;
        }
        Integer rewarded = imp.getRwdd();
        Integer resolvedRewarded = BidRequestOrtb25To26Converter.resolveImpRewarded(rewarded, extImp);
        return ObjectUtils.anyNotNull((Object[])new Object[]{resolvedRewarded, resolvedExtImp = BidRequestOrtb25To26Converter.resolveImpExt(extImp)}) ? imp.toBuilder().rwdd(resolvedRewarded != null ? resolvedRewarded : rewarded).ext(resolvedExtImp != null ? resolvedExtImp : extImp).build() : null;
    }

    private static Integer resolveImpRewarded(Integer rewarded, ObjectNode extImp) {
        if (rewarded != null) {
            return null;
        }
        JsonNode rewardedNode = extImp.at(IMP_EXT_PREBID_REWARDED);
        return rewardedNode.isIntegralNumber() ? Integer.valueOf(rewardedNode.asInt()) : null;
    }

    private static ObjectNode resolveImpExt(ObjectNode extImp) {
        JsonNode rewardedNode = extImp.at(IMP_EXT_PREBID_REWARDED);
        if (!rewardedNode.isIntegralNumber()) {
            return null;
        }
        ObjectNode modifiedExtImp = extImp.deepCopy();
        ((ObjectNode)modifiedExtImp.get(PREBID_FIELD)).remove(IS_REWARDED_INVENTORY_FIELD);
        return modifiedExtImp;
    }

    private static Source moveSourceData(Source source) {
        ExtSource resolvedExtSource;
        if (source == null) {
            return null;
        }
        ExtSource extSource = source.getExt();
        if (extSource == null) {
            return null;
        }
        SupplyChain supplyChain = source.getSchain();
        SupplyChain resolvedSupplyChain = supplyChain == null ? extSource.getSchain() : null;
        return ObjectUtils.anyNotNull((Object[])new Object[]{resolvedSupplyChain, resolvedExtSource = BidRequestOrtb25To26Converter.resolveSourceExt(extSource)}) ? source.toBuilder().schain(resolvedSupplyChain != null ? resolvedSupplyChain : supplyChain).ext(resolvedExtSource != null ? BidRequestOrtb25To26Converter.nullIfEmpty(resolvedExtSource) : extSource).build() : null;
    }

    private static ExtSource resolveSourceExt(ExtSource extSource) {
        if (extSource.getSchain() == null) {
            return null;
        }
        ExtSource modifiedExtSource = ExtSource.of(null);
        BidRequestOrtb25To26Converter.copyProperties(extSource, modifiedExtSource);
        return modifiedExtSource;
    }

    private static void copyProperties(FlexibleExtension source, FlexibleExtension target) {
        Optional.ofNullable(source).map(FlexibleExtension::getProperties).ifPresent(target::addProperties);
    }

    private static Regs moveRegsData(Regs regs) {
        ExtRegs resolvedExtRegs;
        String usPrivacy;
        String resolvedUsPrivacy;
        if (regs == null) {
            return null;
        }
        ExtRegs extRegs = regs.getExt();
        if (extRegs == null) {
            return null;
        }
        Integer gdpr = regs.getGdpr();
        Integer resolvedGdpr = gdpr == null ? extRegs.getGdpr() : null;
        return ObjectUtils.anyNotNull((Object[])new Object[]{resolvedGdpr, resolvedUsPrivacy = (usPrivacy = regs.getUsPrivacy()) == null ? extRegs.getUsPrivacy() : null, resolvedExtRegs = BidRequestOrtb25To26Converter.resolveRegsExt(extRegs)}) ? regs.toBuilder().gdpr(resolvedGdpr != null ? resolvedGdpr : gdpr).usPrivacy(resolvedUsPrivacy != null ? resolvedUsPrivacy : usPrivacy).ext(resolvedExtRegs != null ? BidRequestOrtb25To26Converter.nullIfEmpty(resolvedExtRegs) : extRegs).build() : null;
    }

    private static ExtRegs resolveRegsExt(ExtRegs extRegs) {
        if (extRegs == null || BidRequestOrtb25To26Converter.allNull(extRegs.getGdpr(), extRegs.getUsPrivacy())) {
            return null;
        }
        ExtRegs modifiedExtRegs = ExtRegs.of(null, null, extRegs.getGpc());
        BidRequestOrtb25To26Converter.copyProperties(extRegs, modifiedExtRegs);
        return modifiedExtRegs;
    }

    private static boolean allNull(Object ... objects) {
        return !ObjectUtils.anyNotNull((Object[])objects);
    }

    private static User moveUserData(User user) {
        ExtUser resolvedExtUser;
        List<Eid> eids;
        List<Eid> resolvedEids;
        if (user == null) {
            return null;
        }
        ExtUser extUser = user.getExt();
        if (extUser == null) {
            return null;
        }
        String consent = user.getConsent();
        String resolvedConsent = consent == null ? extUser.getConsent() : null;
        return ObjectUtils.anyNotNull((Object[])new Object[]{resolvedConsent, resolvedEids = BidRequestOrtb25To26Converter.resolveUserEids(eids = user.getEids(), extUser), resolvedExtUser = BidRequestOrtb25To26Converter.resolveUserExt(extUser)}) ? user.toBuilder().consent(resolvedConsent != null ? resolvedConsent : consent).eids(resolvedEids != null ? resolvedEids : eids).ext(resolvedExtUser != null ? BidRequestOrtb25To26Converter.nullIfEmpty(resolvedExtUser) : extUser).build() : null;
    }

    private static List<Eid> resolveUserEids(List<Eid> eids, ExtUser extUser) {
        return eids == null ? extUser.getEids() : null;
    }

    private static ExtUser resolveUserExt(ExtUser extUser) {
        if (extUser == null || BidRequestOrtb25To26Converter.allNull(extUser.getConsent(), extUser.getEids())) {
            return null;
        }
        ExtUser modifiedExtUser = extUser.toBuilder().consent(null).eids(null).build();
        BidRequestOrtb25To26Converter.copyProperties(extUser, modifiedExtUser);
        return modifiedExtUser;
    }

    private static ExtSource nullIfEmpty(ExtSource extSource) {
        return extSource.getSchain() == null && MapUtils.isEmpty(extSource.getProperties()) ? null : extSource;
    }

    private static ExtUser nullIfEmpty(ExtUser ext) {
        return ext.isEmpty() ? null : ext;
    }

    private static ExtRegs nullIfEmpty(ExtRegs ext) {
        return BidRequestOrtb25To26Converter.allNull(ext.getGdpr(), ext.getUsPrivacy(), ext.getGpc()) && MapUtils.isEmpty(ext.getProperties()) ? null : ext;
    }
}

