/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.versionconverter;

import java.util.Arrays;
import java.util.Map;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConverter;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.auction.versionconverter.down.BidRequestOrtb26To25Converter;
import org.prebid.server.auction.versionconverter.up.BidRequestOrtb25To26Converter;
import org.prebid.server.json.JacksonMapper;

public class BidRequestOrtbVersionConverterFactory {
    private final Map<OrtbVersion, BidRequestOrtbVersionConverter> upConverters = Map.of(OrtbVersion.ORTB_2_5, BidRequestOrtbVersionConverter.identity(), OrtbVersion.ORTB_2_6, BidRequestOrtbVersionConverterFactory.createChain(new BidRequestOrtb25To26Converter()));
    private final Map<OrtbVersion, BidRequestOrtbVersionConverter> downConverters;

    public BidRequestOrtbVersionConverterFactory(JacksonMapper jacksonMapper) {
        this.downConverters = Map.of(OrtbVersion.ORTB_2_5, BidRequestOrtbVersionConverterFactory.createChain(new BidRequestOrtb26To25Converter(jacksonMapper)), OrtbVersion.ORTB_2_6, BidRequestOrtbVersionConverter.identity());
    }

    static BidRequestOrtbVersionConverter createChain(BidRequestOrtbVersionConverter ... converters) {
        return Arrays.stream(converters).reduce(BidRequestOrtbVersionConverter::andThen).orElseThrow();
    }

    public BidRequestOrtbVersionConverter getConverter(OrtbVersion fromVersion, OrtbVersion toVersion) {
        if (fromVersion.ordinal() <= toVersion.ordinal()) {
            return BidRequestOrtbVersionConverterFactory.getConverterFrom(this.upConverters, toVersion);
        }
        return BidRequestOrtbVersionConverterFactory.getConverterFrom(this.downConverters, toVersion);
    }

    private static BidRequestOrtbVersionConverter getConverterFrom(Map<OrtbVersion, BidRequestOrtbVersionConverter> converters, OrtbVersion targetVersion) {
        BidRequestOrtbVersionConverter converter = converters.get((Object)targetVersion);
        if (converter == null) {
            throw new IllegalArgumentException("Unsupported OpenRTB version for conversion.");
        }
        return converter;
    }
}

