/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Regs;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.prebid.server.auction.DebugResolver;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.InterstitialProcessor;
import org.prebid.server.auction.OrtbTypesResolver;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.StoredRequestProcessor;
import org.prebid.server.auction.gpp.AuctionGppService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionStoredResult;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.auction.requestfactory.Ortb2RequestFactory;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.settings.model.Account;

public class AuctionRequestFactory {
    private final long maxRequestSize;
    private final Ortb2RequestFactory ortb2RequestFactory;
    private final StoredRequestProcessor storedRequestProcessor;
    private final BidRequestOrtbVersionConversionManager ortbVersionConversionManager;
    private final AuctionGppService gppService;
    private final ImplicitParametersExtractor paramsExtractor;
    private final Ortb2ImplicitParametersResolver paramsResolver;
    private final InterstitialProcessor interstitialProcessor;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final DebugResolver debugResolver;
    private final JacksonMapper mapper;
    private final OrtbTypesResolver ortbTypesResolver;
    private static final String ENDPOINT = Endpoint.openrtb2_auction.value();

    public AuctionRequestFactory(long maxRequestSize, Ortb2RequestFactory ortb2RequestFactory, StoredRequestProcessor storedRequestProcessor, BidRequestOrtbVersionConversionManager ortbVersionConversionManager, AuctionGppService gppService, ImplicitParametersExtractor paramsExtractor, Ortb2ImplicitParametersResolver paramsResolver, InterstitialProcessor interstitialProcessor, OrtbTypesResolver ortbTypesResolver, PrivacyEnforcementService privacyEnforcementService, DebugResolver debugResolver, JacksonMapper mapper) {
        this.maxRequestSize = maxRequestSize;
        this.ortb2RequestFactory = Objects.requireNonNull(ortb2RequestFactory);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.ortbVersionConversionManager = Objects.requireNonNull(ortbVersionConversionManager);
        this.gppService = Objects.requireNonNull(gppService);
        this.paramsExtractor = Objects.requireNonNull(paramsExtractor);
        this.paramsResolver = Objects.requireNonNull(paramsResolver);
        this.interstitialProcessor = Objects.requireNonNull(interstitialProcessor);
        this.ortbTypesResolver = Objects.requireNonNull(ortbTypesResolver);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.debugResolver = Objects.requireNonNull(debugResolver);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Future<AuctionContext> fromRequest(RoutingContext routingContext, long startTime) {
        String body;
        try {
            body = this.extractAndValidateBody(routingContext);
        }
        catch (InvalidRequestException e) {
            return Future.failedFuture((Throwable)e);
        }
        AuctionContext initialAuctionContext = this.ortb2RequestFactory.createAuctionContext(Endpoint.openrtb2_auction, MetricName.openrtb2web);
        return this.ortb2RequestFactory.executeEntrypointHooks(routingContext, body, initialAuctionContext).compose(httpRequest -> this.parseBidRequest((HttpRequestContext)httpRequest, initialAuctionContext.getPrebidErrors()).map(bidRequest -> this.ortb2RequestFactory.enrichAuctionContext(initialAuctionContext, (HttpRequestContext)httpRequest, (BidRequest)bidRequest, startTime).with(AuctionRequestFactory.requestTypeMetric(bidRequest)))).compose(auctionContext -> this.ortb2RequestFactory.fetchAccount((AuctionContext)auctionContext).map(auctionContext::with)).map(auctionContext -> auctionContext.with(this.debugResolver.debugContextFrom((AuctionContext)auctionContext))).compose(auctionContext -> this.gppService.contextFrom((AuctionContext)auctionContext).map(auctionContext::with)).compose(auctionContext -> this.ortb2RequestFactory.activityInfrastructureFrom((AuctionContext)auctionContext).map(auctionContext::with)).compose(auctionContext -> this.ortb2RequestFactory.executeRawAuctionRequestHooks((AuctionContext)auctionContext).map(auctionContext::with)).compose(auctionContext -> this.updateAndValidateBidRequest((AuctionContext)auctionContext).map(auctionContext::with)).compose(auctionContext -> this.privacyEnforcementService.contextFromBidRequest((AuctionContext)auctionContext).map(auctionContext::with)).map(auctionContext -> auctionContext.with(this.ortb2RequestFactory.enrichBidRequestWithAccountAndPrivacyData((AuctionContext)auctionContext))).compose(auctionContext -> this.ortb2RequestFactory.executeProcessedAuctionRequestHooks((AuctionContext)auctionContext).map(auctionContext::with)).compose(this.ortb2RequestFactory::populateUserAdditionalInfo).map(this.ortb2RequestFactory::enrichWithPriceFloors).map(auctionContext -> this.ortb2RequestFactory.updateTimeout((AuctionContext)auctionContext, startTime)).recover(this.ortb2RequestFactory::restoreResultFromRejection);
    }

    private String extractAndValidateBody(RoutingContext routingContext) {
        String body = routingContext.getBodyAsString();
        if (body == null) {
            throw new InvalidRequestException("Incoming request has no body");
        }
        if ((long)body.length() > this.maxRequestSize) {
            throw new InvalidRequestException("Request size exceeded max size of %d bytes.".formatted(this.maxRequestSize));
        }
        return body;
    }

    private Future<BidRequest> parseBidRequest(HttpRequestContext httpRequest, List<String> errors) {
        try {
            JsonNode bidRequestNode = this.bodyAsJsonNode(httpRequest.getBody());
            String referer = this.paramsExtractor.refererFrom(httpRequest);
            this.ortbTypesResolver.normalizeBidRequest(bidRequestNode, errors, referer);
            return Future.succeededFuture((Object)this.jsonNodeAsBidRequest(bidRequestNode)).map(bidRequest -> this.fillWithValuesFromHttpRequest((BidRequest)bidRequest, httpRequest));
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private JsonNode bodyAsJsonNode(String body) {
        try {
            return this.mapper.mapper().readTree(body);
        }
        catch (IOException e) {
            throw new InvalidRequestException("Error decoding bidRequest: " + e.getMessage());
        }
    }

    private BidRequest jsonNodeAsBidRequest(JsonNode bidRequestNode) {
        try {
            return (BidRequest)this.mapper.mapper().treeToValue((TreeNode)bidRequestNode, BidRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Error decoding bidRequest: " + e.getMessage());
        }
    }

    private BidRequest fillWithValuesFromHttpRequest(BidRequest bidRequest, HttpRequestContext httpRequest) {
        return !this.containsRegsExtGpc(bidRequest) ? bidRequest.toBuilder().regs(this.fillRegsWithValuesFromHttpRequest(bidRequest.getRegs(), httpRequest)).build() : bidRequest;
    }

    private boolean containsRegsExtGpc(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest.getRegs()).map(Regs::getExt).map(ExtRegs::getGpc).isPresent();
    }

    private Regs fillRegsWithValuesFromHttpRequest(Regs regs, HttpRequestContext httpRequest) {
        String gpc = this.paramsExtractor.gpcFrom(httpRequest);
        if (gpc == null) {
            return regs;
        }
        ExtRegs extRegs = regs != null ? regs.getExt() : null;
        return (regs != null ? regs.toBuilder() : Regs.builder()).ext(ExtRegs.of(extRegs != null ? extRegs.getGdpr() : null, extRegs != null ? extRegs.getUsPrivacy() : null, gpc)).build();
    }

    private Future<BidRequest> updateAndValidateBidRequest(AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        List<String> debugWarnings = auctionContext.getDebugWarnings();
        return this.storedRequestProcessor.processAuctionRequest(account.getId(), auctionContext.getBidRequest()).compose(auctionStoredResult -> this.updateBidRequest((AuctionStoredResult)auctionStoredResult, auctionContext)).compose(bidRequest -> this.ortb2RequestFactory.validateRequest((BidRequest)bidRequest, auctionContext.getHttpRequest(), debugWarnings)).map(this.interstitialProcessor::process);
    }

    private Future<BidRequest> updateBidRequest(AuctionStoredResult auctionStoredResult, AuctionContext auctionContext) {
        boolean hasStoredBidRequest = auctionStoredResult.hasStoredBidRequest();
        return Future.succeededFuture((Object)auctionStoredResult.bidRequest()).map(this.ortbVersionConversionManager::convertToAuctionSupportedVersion).map(bidRequest -> this.gppService.updateBidRequest((BidRequest)bidRequest, auctionContext)).map(bidRequest -> this.paramsResolver.resolve((BidRequest)bidRequest, auctionContext.getHttpRequest(), ENDPOINT, hasStoredBidRequest));
    }

    private static MetricName requestTypeMetric(BidRequest bidRequest) {
        if (bidRequest.getApp() != null) {
            return MetricName.openrtb2app;
        }
        if (bidRequest.getDooh() != null) {
            return MetricName.openrtb2dooh;
        }
        return MetricName.openrtb2web;
    }
}

