/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.privacycontextfactory;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Site;
import io.vertx.core.Future;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.ConsentType;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.privacy.PrivacyExtractor;
import org.prebid.server.privacy.gdpr.TcfDefinerService;
import org.prebid.server.privacy.gdpr.model.RequestLogInfo;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.AccountPrivacyConfig;

public class AmpPrivacyContextFactory {
    private static final String CONSENT_TYPE_PARAM = "consent_type";
    private final PrivacyExtractor privacyExtractor;
    private final TcfDefinerService tcfDefinerService;
    private final IpAddressHelper ipAddressHelper;
    private final CountryCodeMapper countryCodeMapper;

    public AmpPrivacyContextFactory(PrivacyExtractor privacyExtractor, TcfDefinerService tcfDefinerService, IpAddressHelper ipAddressHelper, CountryCodeMapper countryCodeMapper) {
        this.privacyExtractor = Objects.requireNonNull(privacyExtractor);
        this.tcfDefinerService = Objects.requireNonNull(tcfDefinerService);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.countryCodeMapper = Objects.requireNonNull(countryCodeMapper);
    }

    public Future<PrivacyContext> contextFrom(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        MetricName requestType = auctionContext.getRequestTypeMetric();
        Timeout timeout = auctionContext.getTimeout();
        List<String> errors = auctionContext.getPrebidErrors();
        Privacy initialPrivacy = this.privacyExtractor.validPrivacyFrom(bidRequest, errors);
        Privacy strippedPrivacy = this.stripPrivacy(initialPrivacy, auctionContext);
        Device device = bidRequest.getDevice();
        Account account = auctionContext.getAccount();
        return this.tcfDefinerService.resolveTcfContext(strippedPrivacy, this.resolveAlpha2CountryCode(device), this.resolveIpAddress(device, strippedPrivacy), this.extractGdprConfig(account), requestType, AmpPrivacyContextFactory.requestLogInfo(requestType, bidRequest, account.getId()), timeout).map(tcfContext -> AmpPrivacyContextFactory.logWarnings(auctionContext.getDebugWarnings(), tcfContext)).map(tcfContext -> PrivacyContext.of(strippedPrivacy, tcfContext, tcfContext.getIpAddress()));
    }

    private Privacy stripPrivacy(Privacy privacy, AuctionContext auctionContext) {
        List<String> errors = auctionContext.getPrebidErrors();
        String consentTypeParam = auctionContext.getHttpRequest().getQueryParams().get(CONSENT_TYPE_PARAM);
        ConsentType consentType = ConsentType.from(consentTypeParam);
        if (consentType == ConsentType.TCF_V1) {
            errors.add("Consent type tcfV1 is no longer supported");
            return privacy.withoutConsent();
        }
        return privacy;
    }

    private AccountGdprConfig extractGdprConfig(Account account) {
        AccountPrivacyConfig accountPrivacyConfig = account != null ? account.getPrivacy() : null;
        return accountPrivacyConfig != null ? accountPrivacyConfig.getGdpr() : null;
    }

    private static TcfContext logWarnings(List<String> debugWarnings, TcfContext tcfContext) {
        debugWarnings.addAll(tcfContext.getWarnings());
        return tcfContext;
    }

    private String resolveAlpha2CountryCode(Device device) {
        Geo geo = device != null ? device.getGeo() : null;
        String alpha3CountryCode = geo != null ? geo.getCountry() : null;
        return this.countryCodeMapper.mapToAlpha2(alpha3CountryCode);
    }

    private String resolveIpAddress(Device device, Privacy privacy) {
        String ipV6Address;
        String ipV4Address;
        boolean shouldBeMasked = Objects.equals(privacy.getCoppa(), 1) || device != null && Objects.equals(device.getLmt(), 1);
        String string = ipV4Address = device != null ? device.getIp() : null;
        if (StringUtils.isNotBlank((CharSequence)ipV4Address)) {
            return shouldBeMasked ? this.ipAddressHelper.maskIpv4(ipV4Address) : ipV4Address;
        }
        String string2 = ipV6Address = device != null ? device.getIpv6() : null;
        if (StringUtils.isNotBlank((CharSequence)ipV6Address)) {
            return shouldBeMasked ? this.ipAddressHelper.anonymizeIpv6(ipV6Address) : ipV6Address;
        }
        return null;
    }

    private static RequestLogInfo requestLogInfo(MetricName requestType, BidRequest bidRequest, String accountId) {
        if (requestType == MetricName.openrtb2web) {
            Site site = bidRequest != null ? bidRequest.getSite() : null;
            String refUrl = site != null ? site.getRef() : null;
            return RequestLogInfo.of(requestType, refUrl, accountId);
        }
        return RequestLogInfo.of(requestType, null, accountId);
    }
}

