/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.EncodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;

public class CachedDebugLog {
    public static final String CACHE_TYPE = "xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final boolean enabled;
    private final int ttl;
    private final Pattern escapeSymbolsPattern;
    private String cacheKey;
    private String request;
    private String headers;
    private String extBidResponse;
    private Boolean hasBids;
    private final JacksonMapper jacksonMapper;

    public CachedDebugLog(boolean enabled, int ttl, Pattern escapeSymbolsPattern, JacksonMapper jacksonMapper) {
        this.enabled = enabled;
        this.ttl = ttl;
        this.escapeSymbolsPattern = escapeSymbolsPattern;
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setRequest(String request) {
        this.request = request != null ? request : "";
    }

    public void setHeadersLog(CaseInsensitiveMultiMap headers) {
        this.headers = headers != null ? headers.toString() : "";
    }

    public void setExtBidResponse(ExtBidResponse response) {
        try {
            this.extBidResponse = response != null ? this.jacksonMapper.encodeToString(response) : "";
        }
        catch (EncodeException ex) {
            String errorMessage = "Unable to marshal response ext for debugging with a reason: " + ex.getMessage();
            this.extBidResponse = errorMessage;
            throw new PreBidException(errorMessage);
        }
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setHasBids(boolean hasBids) {
        this.hasBids = hasBids;
    }

    public boolean hasBids() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.hasBids, (boolean)true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setErrors(List<String> errors) {
        if (StringUtils.isBlank((CharSequence)this.extBidResponse) && CollectionUtils.isEmpty(errors)) {
            this.extBidResponse = "No response or errors created";
            return;
        }
        this.extBidResponse = "%s\nErrors:\n%s".formatted(StringUtils.isBlank((CharSequence)this.extBidResponse) ? "" : this.extBidResponse, String.join((CharSequence)"\n", errors));
    }

    public String buildCacheBody() {
        String resolvedResponse = this.prepareValueToPublish(this.extBidResponse, "Response");
        String resoledRequest = this.prepareValueToPublish(this.request, "Request");
        String resolvedHeaders = this.prepareValueToPublish(this.headers, "Headers");
        return "%s<Log>\n%s\n%s\n%s\n</Log>".formatted(XML_HEADER, resoledRequest, resolvedResponse, resolvedHeaders);
    }

    private String prepareValueToPublish(String value, String fieldName) {
        return "<%s>%s</%s>".formatted(fieldName, value != null ? this.escapeNonXmlSymbols(value) : "", fieldName);
    }

    private String escapeNonXmlSymbols(String value) {
        return this.escapeSymbolsPattern != null ? this.escapeSymbolsPattern.matcher(value).replaceAll("") : value;
    }
}

