/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp.model;

import com.iab.gpp.encoder.GppModel;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextUtils;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.exception.PreBidException;

public class GppContextCreator {
    private GppContextCreator() {
    }

    public static GppContextBuilder from(String gpp, List<Integer> gppSid) {
        GppModel gppModel;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            gppModel = GppContextUtils.gppModel(gpp);
        }
        catch (PreBidException e) {
            gppModel = null;
            errors.add(e.getMessage());
        }
        Set<Integer> sectionIds = gppSid != null ? Set.copyOf(gppSid) : null;
        return GppContextBuilder.of(GppContext.Scope.of(gppModel, sectionIds), GppContext.Regions.builder(), errors);
    }

    public static final class GppContextBuilder {
        private final GppContext.Scope scope;
        private final GppContext.Regions.RegionsBuilder regionsBuilder;
        private final List<String> errors;

        public GppContextBuilder with(Privacy privacy) {
            GppContextUtils.withPrivacy(this.regionsBuilder, privacy);
            return this;
        }

        public GppContextWrapper build() {
            return GppContextWrapper.of(new GppContext(this.scope, this.regionsBuilder.build()), this.errors);
        }

        public GppContext.Scope getScope() {
            return this.scope;
        }

        public GppContext.Regions.RegionsBuilder getRegionsBuilder() {
            return this.regionsBuilder;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GppContextBuilder)) {
                return false;
            }
            GppContextBuilder other = (GppContextBuilder)o;
            GppContext.Scope this$scope = this.getScope();
            GppContext.Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
                return false;
            }
            GppContext.Regions.RegionsBuilder this$regionsBuilder = this.getRegionsBuilder();
            GppContext.Regions.RegionsBuilder other$regionsBuilder = other.getRegionsBuilder();
            if (this$regionsBuilder == null ? other$regionsBuilder != null : !this$regionsBuilder.equals(other$regionsBuilder)) {
                return false;
            }
            List<String> this$errors = this.getErrors();
            List<String> other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GppContext.Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            GppContext.Regions.RegionsBuilder $regionsBuilder = this.getRegionsBuilder();
            result = result * 59 + ($regionsBuilder == null ? 43 : $regionsBuilder.hashCode());
            List<String> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            return result;
        }

        public String toString() {
            return "GppContextCreator.GppContextBuilder(scope=" + this.getScope() + ", regionsBuilder=" + this.getRegionsBuilder() + ", errors=" + this.getErrors() + ")";
        }

        @ConstructorProperties(value={"scope", "regionsBuilder", "errors"})
        private GppContextBuilder(GppContext.Scope scope, GppContext.Regions.RegionsBuilder regionsBuilder, List<String> errors) {
            this.scope = scope;
            this.regionsBuilder = regionsBuilder;
            this.errors = errors;
        }

        private static GppContextBuilder of(GppContext.Scope scope, GppContext.Regions.RegionsBuilder regionsBuilder, List<String> errors) {
            return new GppContextBuilder(scope, regionsBuilder, errors);
        }
    }
}

