/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.adjustment;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestBidAdjustmentFactors;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;

public class FloorAdjustmentFactorResolver {
    public BigDecimal resolve(ImpMediaType impMediaType, ExtRequestBidAdjustmentFactors adjustmentFactors, String bidder) {
        Set<ImpMediaType> impMediaTypes = impMediaType != null ? EnumSet.of(impMediaType) : Collections.emptySet();
        return this.resolve(impMediaTypes, adjustmentFactors, bidder);
    }

    public BigDecimal resolve(Set<ImpMediaType> impMediaTypes, ExtRequestBidAdjustmentFactors adjustmentFactors, String bidder) {
        BigDecimal effectiveBidderAdjustmentFactor;
        EnumMap<ImpMediaType, Map<String, BigDecimal>> adjustmentFactorsByMediaTypes = adjustmentFactors.getMediatypes();
        BigDecimal bidderAdjustmentFactor = adjustmentFactors.getAdjustments().get(bidder);
        BigDecimal bigDecimal = effectiveBidderAdjustmentFactor = bidderAdjustmentFactor != null ? bidderAdjustmentFactor : BigDecimal.ONE;
        if (MapUtils.isEmpty(adjustmentFactorsByMediaTypes)) {
            return effectiveBidderAdjustmentFactor;
        }
        BigDecimal mediaTypeMinFactor = impMediaTypes.stream().map(adjustmentFactorsByMediaTypes::get).map(bidderToFactor -> MapUtils.isNotEmpty((Map)bidderToFactor) ? (BigDecimal)bidderToFactor.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)bidder)).map(Map.Entry::getValue).findFirst().orElse(null) : effectiveBidderAdjustmentFactor).filter(Objects::nonNull).min(Comparator.comparing(Function.identity())).orElse(null);
        return FloorAdjustmentFactorResolver.createFactorValue(mediaTypeMinFactor, bidderAdjustmentFactor);
    }

    private static BigDecimal createFactorValue(BigDecimal mediaTypeFactor, BigDecimal adjustmentFactor) {
        if (mediaTypeFactor != null && adjustmentFactor != null) {
            return mediaTypeFactor.min(adjustmentFactor);
        }
        if (mediaTypeFactor != null) {
            return mediaTypeFactor;
        }
        if (adjustmentFactor != null) {
            return adjustmentFactor;
        }
        return BigDecimal.ONE;
    }
}

