/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.proto.openrtb.ext.request.ExtGranularityRange;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;

public class PriceGranularity {
    private static final EnumMap<PriceGranularityType, PriceGranularity> STRING_TO_CUSTOM_PRICE_GRANULARITY = new EnumMap(PriceGranularityType.class);
    public static final PriceGranularity DEFAULT;
    private List<ExtGranularityRange> ranges;
    private BigDecimal rangesMax;
    private Integer precision;

    private PriceGranularity(List<ExtGranularityRange> ranges, BigDecimal rangesMax, Integer precision) {
        this.ranges = ranges;
        this.rangesMax = rangesMax;
        this.precision = precision;
    }

    public static PriceGranularity createFromExtPriceGranularity(ExtPriceGranularity extPriceGranularity) {
        return PriceGranularity.createFromRanges(extPriceGranularity.getPrecision(), extPriceGranularity.getRanges());
    }

    public static PriceGranularity createFromString(String stringPriceGranularity) {
        if (PriceGranularity.isValidStringPriceGranularityType(stringPriceGranularity)) {
            return STRING_TO_CUSTOM_PRICE_GRANULARITY.get((Object)PriceGranularityType.valueOf(stringPriceGranularity));
        }
        throw new PreBidException("Invalid string price granularity with value: " + stringPriceGranularity);
    }

    public List<ExtGranularityRange> getRanges() {
        return this.ranges;
    }

    BigDecimal getRangesMax() {
        return this.rangesMax;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    private static void putStringPriceGranularity(PriceGranularityType type, Integer precision, ExtGranularityRange ... ranges) {
        STRING_TO_CUSTOM_PRICE_GRANULARITY.put(type, PriceGranularity.createFromRanges(precision, Arrays.asList(ranges)));
    }

    public static PriceGranularity createFromRanges(Integer precision, List<ExtGranularityRange> ranges) {
        BigDecimal rangeMax = CollectionUtils.emptyIfNull(ranges).stream().filter(Objects::nonNull).map(ExtGranularityRange::getMax).filter(Objects::nonNull).max(BigDecimal::compareTo).orElseThrow(() -> new IllegalArgumentException("Price granularity error: Max value among all ranges was not found. Please check if ranges are valid"));
        return new PriceGranularity(ranges, rangeMax, precision);
    }

    private static ExtGranularityRange range(int max, double increment) {
        return ExtGranularityRange.of(BigDecimal.valueOf(max), BigDecimal.valueOf(increment));
    }

    private static boolean isValidStringPriceGranularityType(String stringPriceGranularity) {
        return EnumUtils.isValidEnum(PriceGranularityType.class, (String)stringPriceGranularity);
    }

    public PriceGranularity() {
    }

    static {
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.low, 2, PriceGranularity.range(5, 0.5));
        ExtGranularityRange medRange = PriceGranularity.range(20, 0.1);
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.medium, 2, medRange);
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.med, 2, medRange);
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.high, 2, PriceGranularity.range(20, 0.01));
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.auto, 2, PriceGranularity.range(5, 0.05), PriceGranularity.range(10, 0.1), PriceGranularity.range(20, 0.5));
        PriceGranularity.putStringPriceGranularity(PriceGranularityType.dense, 2, PriceGranularity.range(3, 0.01), PriceGranularity.range(8, 0.05), PriceGranularity.range(20, 0.5));
        DEFAULT = STRING_TO_CUSTOM_PRICE_GRANULARITY.get((Object)PriceGranularityType.med);
    }

    static enum PriceGranularityType {
        low,
        medium,
        med,
        high,
        auto,
        dense;

    }
}

