/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.log.ConditionalLogger;

public class OrtbTypesResolver {
    private static final Logger logger = LoggerFactory.getLogger(OrtbTypesResolver.class);
    private static final ConditionalLogger ORTB_TYPES_RESOLVING_LOGGER = new ConditionalLogger("ortb_resolving_warnings", logger);
    private static final String USER = "user";
    private static final String APP = "app";
    private static final String SITE = "site";
    private static final String CONTEXT = "context";
    private static final String BIDREQUEST = "bidrequest";
    private static final String TARGETING = "targeting";
    private static final String UNKNOWN_REFERER = "unknown referer";
    private static final String DATA = "data";
    private static final String EXT = "ext";
    private static final Map<String, Set<String>> FIRST_ARRAY_ELEMENT_STANDARD_FIELDS;
    private static final Map<String, Set<String>> FIRST_ARRAY_ELEMENT_REQUEST_FIELDS;
    private static final Map<String, Set<String>> COMMA_SEPARATED_ELEMENT_FIELDS;
    private final double logSamplingRate;
    private final JacksonMapper jacksonMapper;
    private final JsonMerger jsonMerger;

    public OrtbTypesResolver(double logSamplingRate, JacksonMapper jacksonMapper, JsonMerger jsonMerger) {
        this.logSamplingRate = logSamplingRate;
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
    }

    public void normalizeBidRequest(JsonNode bidRequest, List<String> warnings, String referer) {
        ArrayList<String> resolverWarnings = new ArrayList<String>();
        String rowOriginBidRequest = this.getOriginalRowContainerNode(bidRequest);
        this.normalizeRequestFpdFields(bidRequest, resolverWarnings);
        JsonNode bidderConfigs = bidRequest.path(EXT).path("prebid").path("bidderconfig");
        if (!bidderConfigs.isMissingNode() && bidderConfigs.isArray()) {
            for (JsonNode bidderConfig : bidderConfigs) {
                this.mergeFpdFieldsToOrtb2(bidderConfig);
                JsonNode ortb2Config = bidderConfig.path("config").path("ortb2");
                if (ortb2Config.isMissingNode()) continue;
                this.normalizeStandardFpdFields(ortb2Config, resolverWarnings, "bidrequest.ext.prebid.bidderconfig");
            }
        }
        this.processWarnings(resolverWarnings, warnings, rowOriginBidRequest, referer, BIDREQUEST);
    }

    private String getOriginalRowContainerNode(JsonNode bidRequest) {
        try {
            return this.jacksonMapper.mapper().writeValueAsString((Object)bidRequest);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Failed to decode container node to string");
        }
    }

    private void mergeFpdFieldsToOrtb2(JsonNode bidderConfig) {
        ObjectNode ortbObjectNode;
        JsonNode updatedOrtbUser;
        JsonNode config = bidderConfig.path("config");
        JsonNode configFpd = config.path("fpd");
        if (configFpd.isMissingNode()) {
            return;
        }
        JsonNode configOrtb = config.path("ortb2");
        JsonNode fpdContext = configFpd.get(CONTEXT);
        JsonNode ortbSite = configOrtb.get(SITE);
        JsonNode updatedOrtbSite = ortbSite == null ? fpdContext : (fpdContext != null ? this.jsonMerger.merge(fpdContext, ortbSite) : null);
        JsonNode fpdUser = configFpd.get(USER);
        JsonNode ortbUser = configOrtb.get(USER);
        Object object = ortbUser == null ? fpdUser : (updatedOrtbUser = fpdUser != null ? this.jsonMerger.merge(fpdUser, ortbUser) : null);
        if (updatedOrtbUser == null && updatedOrtbSite == null) {
            return;
        }
        ObjectNode objectNode = ortbObjectNode = configOrtb.isMissingNode() ? this.jacksonMapper.mapper().createObjectNode() : (ObjectNode)configOrtb;
        if (updatedOrtbSite != null) {
            ortbObjectNode.set(SITE, updatedOrtbSite);
        }
        if (updatedOrtbUser != null) {
            ortbObjectNode.set(USER, updatedOrtbUser);
        }
        ((ObjectNode)config).set("ortb2", (JsonNode)ortbObjectNode);
    }

    public void normalizeTargeting(JsonNode targeting, List<String> warnings, String referer) {
        ArrayList<String> resolverWarnings = new ArrayList<String>();
        String rowOriginTargeting = this.getOriginalRowContainerNode(targeting);
        this.normalizeStandardFpdFields(targeting, resolverWarnings, TARGETING);
        this.processWarnings(resolverWarnings, warnings, rowOriginTargeting, referer, TARGETING);
    }

    private void normalizeStandardFpdFields(JsonNode fpdContainerNode, List<String> warnings, String nodePrefix) {
        String normalizedNodePrefix;
        String string = normalizedNodePrefix = nodePrefix.endsWith(".") ? nodePrefix : nodePrefix.concat(".");
        if (fpdContainerNode != null && fpdContainerNode.isObject()) {
            ObjectNode fpdContainerObjectNode = (ObjectNode)fpdContainerNode;
            this.updateWithNormalizedNode(fpdContainerObjectNode, USER, FIRST_ARRAY_ELEMENT_STANDARD_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, normalizedNodePrefix, warnings);
            this.updateWithNormalizedNode(fpdContainerObjectNode, APP, FIRST_ARRAY_ELEMENT_STANDARD_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, normalizedNodePrefix, warnings);
            this.updateWithNormalizedNode(fpdContainerObjectNode, SITE, FIRST_ARRAY_ELEMENT_STANDARD_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, normalizedNodePrefix, warnings);
        }
    }

    private void normalizeRequestFpdFields(JsonNode fpdContainerNode, List<String> warnings) {
        if (fpdContainerNode != null && fpdContainerNode.isObject()) {
            ObjectNode fpdContainerObjectNode = (ObjectNode)fpdContainerNode;
            String bidRequestPrefix = "bidrequest.";
            this.updateWithNormalizedNode(fpdContainerObjectNode, USER, FIRST_ARRAY_ELEMENT_REQUEST_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, "bidrequest.", warnings);
            this.updateWithNormalizedNode(fpdContainerObjectNode, APP, FIRST_ARRAY_ELEMENT_REQUEST_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, "bidrequest.", warnings);
            this.updateWithNormalizedNode(fpdContainerObjectNode, SITE, FIRST_ARRAY_ELEMENT_REQUEST_FIELDS, COMMA_SEPARATED_ELEMENT_FIELDS, "bidrequest.", warnings);
        }
    }

    private void updateWithNormalizedNode(ObjectNode containerNode, String nodeNameToNormalize, Map<String, Set<String>> firstArrayElementsFields, Map<String, Set<String>> commaSeparatedElementFields, String nodePrefix, List<String> warnings) {
        JsonNode normalizedNode = this.normalizeNode(containerNode.get(nodeNameToNormalize), nodeNameToNormalize, firstArrayElementsFields, commaSeparatedElementFields, nodePrefix, warnings);
        if (normalizedNode != null) {
            containerNode.set(nodeNameToNormalize, normalizedNode);
        } else {
            containerNode.remove(nodeNameToNormalize);
        }
    }

    private JsonNode normalizeNode(JsonNode containerNode, String nodeName, Map<String, Set<String>> firstArrayElementsFields, Map<String, Set<String>> commaSeparatedElementFields, String nodePrefix, List<String> warnings) {
        if (containerNode != null) {
            if (containerNode.isObject()) {
                ObjectNode containerObjectNode = (ObjectNode)containerNode;
                CollectionUtils.emptyIfNull((Collection)firstArrayElementsFields.get(nodeName)).forEach(fieldName -> this.updateWithNormalizedField(containerObjectNode, (String)fieldName, () -> this.toFirstElementTextNode(containerObjectNode, (String)fieldName, nodeName, nodePrefix, warnings)));
                CollectionUtils.emptyIfNull((Collection)commaSeparatedElementFields.get(nodeName)).forEach(fieldName -> this.updateWithNormalizedField(containerObjectNode, (String)fieldName, () -> this.toCommaSeparatedTextNode(containerObjectNode, (String)fieldName, nodeName, nodePrefix, warnings)));
                this.normalizeDataExtension(containerObjectNode, nodeName, nodePrefix, warnings);
            } else {
                warnings.add("%s%s field ignored. Expected type is object, but was `%s`.".formatted(nodePrefix, nodeName, containerNode.getNodeType().name()));
                return null;
            }
        }
        return containerNode;
    }

    private void updateWithNormalizedField(ObjectNode containerNode, String fieldName, Supplier<JsonNode> normalizationSupplier) {
        JsonNode normalizedField = normalizationSupplier.get();
        if (normalizedField == null) {
            containerNode.remove(fieldName);
        } else {
            containerNode.set(fieldName, normalizedField);
        }
    }

    private JsonNode toFirstElementTextNode(ObjectNode containerNode, String fieldName, String containerName, String nodePrefix, List<String> warnings) {
        boolean isTextualArray;
        JsonNode node = containerNode.get(fieldName);
        if (node == null || node.isNull() || node.isTextual()) {
            return node;
        }
        boolean isArray = node.isArray();
        ArrayNode arrayNode = isArray ? (ArrayNode)node : null;
        boolean bl = isTextualArray = arrayNode != null && OrtbTypesResolver.isTextualArray(arrayNode) && !arrayNode.isEmpty();
        if (isTextualArray && !arrayNode.isEmpty()) {
            warnings.add("Incorrect type for first party data field %s%s.%s, expected is string, but was an array of strings. Converted to string by taking first element of array.".formatted(nodePrefix, containerName, fieldName));
            return new TextNode(arrayNode.get(0).asText());
        }
        this.warnForExpectedStringArrayType(fieldName, containerName, warnings, nodePrefix, node.getNodeType());
        return null;
    }

    private JsonNode toCommaSeparatedTextNode(ObjectNode containerNode, String fieldName, String containerName, String nodePrefix, List<String> warnings) {
        boolean isTextualArray;
        JsonNode node = containerNode.get(fieldName);
        if (node == null || node.isNull() || node.isTextual()) {
            return node;
        }
        boolean isArray = node.isArray();
        ArrayNode arrayNode = isArray ? (ArrayNode)node : null;
        boolean bl = isTextualArray = arrayNode != null && OrtbTypesResolver.isTextualArray(arrayNode) && !arrayNode.isEmpty();
        if (isTextualArray) {
            warnings.add("Incorrect type for first party data field %s%s.%s, expected is string, but was an array of strings. Converted to string by separating values with comma.".formatted(nodePrefix, containerName, fieldName));
            return new TextNode(StreamSupport.stream(arrayNode.spliterator(), false).map(jsonNode -> (TextNode)jsonNode).map(TextNode::textValue).collect(Collectors.joining(",")));
        }
        this.warnForExpectedStringArrayType(fieldName, containerName, warnings, nodePrefix, node.getNodeType());
        return null;
    }

    private void normalizeDataExtension(ObjectNode containerNode, String containerName, String nodePrefix, List<String> warnings) {
        JsonNode data = containerNode.get(DATA);
        if (data == null || !data.isObject()) {
            return;
        }
        JsonNode extData = containerNode.path(EXT).path(DATA);
        JsonNode ext = containerNode.get(EXT);
        if (!extData.isNull() && !extData.isMissingNode()) {
            JsonNode resolvedExtData = this.jsonMerger.merge(data, extData);
            ((ObjectNode)ext).set(DATA, resolvedExtData);
        } else {
            this.copyDataToExtData(containerNode, containerName, nodePrefix, warnings, data);
        }
        containerNode.remove(DATA);
    }

    private void copyDataToExtData(ObjectNode containerNode, String containerName, String nodePrefix, List<String> warnings, JsonNode data) {
        JsonNode ext = containerNode.get(EXT);
        if (ext != null && ext.isObject()) {
            ((ObjectNode)ext).set(DATA, data);
        } else if (ext != null && !ext.isObject()) {
            warnings.add("Incorrect type for first party data field %s%s.%s, expected is object, but was %s. Replaced with object".formatted(nodePrefix, containerName, EXT, ext.getNodeType()));
            containerNode.set(EXT, this.jacksonMapper.mapper().createObjectNode().set(DATA, data));
        } else {
            containerNode.set(EXT, this.jacksonMapper.mapper().createObjectNode().set(DATA, data));
        }
    }

    private void warnForExpectedStringArrayType(String fieldName, String containerName, List<String> warnings, String nodePrefix, JsonNodeType nodeType) {
        warnings.add("Incorrect type for first party data field %s%s.%s, expected strings, but was `%s`. Failed to convert to correct type.".formatted(nodePrefix, containerName, fieldName, nodeType == JsonNodeType.ARRAY ? "ARRAY of different types" : nodeType.name()));
    }

    private static boolean isTextualArray(ArrayNode arrayNode) {
        return StreamSupport.stream(arrayNode.spliterator(), false).allMatch(JsonNode::isTextual);
    }

    private void processWarnings(List<String> resolverWarning, List<String> warnings, String containerValue, String referer, String containerName) {
        if (CollectionUtils.isNotEmpty(resolverWarning)) {
            warnings.addAll(this.updateWithWarningPrefix(resolverWarning));
            ORTB_TYPES_RESOLVING_LOGGER.warn("WARNINGS: %s. \n Referer = %s and %s = %s".formatted(String.join((CharSequence)"\n", resolverWarning), StringUtils.isNotBlank((CharSequence)referer) ? referer : UNKNOWN_REFERER, containerName, containerValue), this.logSamplingRate);
        }
    }

    private List<String> updateWithWarningPrefix(List<String> resolverWarning) {
        return resolverWarning.stream().map(warning -> "WARNING: " + warning).toList();
    }

    static {
        FIRST_ARRAY_ELEMENT_REQUEST_FIELDS = new HashMap<String, Set<String>>();
        FIRST_ARRAY_ELEMENT_REQUEST_FIELDS.put(USER, new HashSet<String>(Collections.singleton("gender")));
        FIRST_ARRAY_ELEMENT_REQUEST_FIELDS.put(APP, new HashSet<String>(Arrays.asList("id", "name", "bundle", "storeurl", "domain")));
        FIRST_ARRAY_ELEMENT_REQUEST_FIELDS.put(SITE, new HashSet<String>(Arrays.asList("id", "name", "domain", "page", "ref", "search")));
        FIRST_ARRAY_ELEMENT_STANDARD_FIELDS = new HashMap<String, Set<String>>();
        FIRST_ARRAY_ELEMENT_STANDARD_FIELDS.put(USER, new HashSet<String>(Collections.singleton("gender")));
        FIRST_ARRAY_ELEMENT_STANDARD_FIELDS.put(APP, new HashSet<String>(Arrays.asList("name", "bundle", "storeurl", "domain")));
        FIRST_ARRAY_ELEMENT_STANDARD_FIELDS.put(SITE, new HashSet<String>(Arrays.asList("name", "domain", "page", "ref", "search")));
        COMMA_SEPARATED_ELEMENT_FIELDS = new HashMap<String, Set<String>>();
        COMMA_SEPARATED_ELEMENT_FIELDS.put(USER, Collections.singleton("keywords"));
        COMMA_SEPARATED_ELEMENT_FIELDS.put(APP, Collections.singleton("keywords"));
        COMMA_SEPARATED_ELEMENT_FIELDS.put(SITE, Collections.singleton("keywords"));
    }
}

