/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtDeviceInt;
import org.prebid.server.proto.openrtb.ext.request.ExtDevicePrebid;

public class InterstitialProcessor {
    private static final int MAX_SIZES_COUNT = 10;

    public BidRequest process(BidRequest bidRequest) {
        if (bidRequest.getImp().stream().anyMatch(this::isInterstitial)) {
            bidRequest = this.processBidRequest(bidRequest);
        }
        return bidRequest;
    }

    private boolean isInterstitial(Imp imp) {
        return Objects.equals(imp.getInstl(), 1);
    }

    private BidRequest processBidRequest(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        ExtDeviceInt extDeviceInt = this.getExtDeviceInt(device);
        if (extDeviceInt != null) {
            int minWidthPerc = extDeviceInt.getMinWidthPerc();
            int minHeightPerc = extDeviceInt.getMinHeightPerc();
            List<Imp> updatedImps = bidRequest.getImp().stream().map(imp -> this.processInterstitialImp((Imp)imp, device, minWidthPerc, minHeightPerc)).toList();
            bidRequest = bidRequest.toBuilder().imp(updatedImps).build();
        }
        return bidRequest;
    }

    private Imp processInterstitialImp(Imp imp, Device device, int minWidthPerc, int minHeightPerc) {
        Integer maxWidth;
        if (!this.isInterstitial(imp)) {
            return imp;
        }
        Banner banner = imp.getBanner();
        if (banner == null) {
            return imp;
        }
        List<Format> formats = banner.getFormat();
        Format firstFormat = CollectionUtils.isEmpty(formats) ? null : formats.get(0);
        Integer maxHeight = firstFormat != null ? firstFormat.getH() : null;
        Integer n = maxWidth = firstFormat != null ? firstFormat.getW() : null;
        if (maxHeight == null || maxWidth == null || maxHeight == 1 && maxWidth == 1) {
            maxHeight = device.getH();
            maxWidth = device.getW();
        }
        if (maxHeight == null || maxWidth == null) {
            throw new InvalidRequestException("Unable to read max interstitial size for Imp id=%s (No Device sizes and no Format objects)".formatted(imp.getId()));
        }
        double minHeight = (double)maxHeight.intValue() / 100.0 * (double)minHeightPerc;
        double minWidth = (double)maxWidth.intValue() / 100.0 * (double)minWidthPerc;
        List<Format> interstitialFormats = InterstitialSize.getNestedSizes(minWidth, minHeight, maxWidth.intValue(), maxHeight.intValue(), 10).stream().map(interstitialSize -> Format.builder().w(interstitialSize.w).h(interstitialSize.h).build()).toList();
        if (CollectionUtils.isEmpty(interstitialFormats)) {
            return imp;
        }
        return imp.toBuilder().banner(banner.toBuilder().format(interstitialFormats).build()).build();
    }

    private ExtDeviceInt getExtDeviceInt(Device device) {
        ExtDevice extDevice = device != null ? device.getExt() : null;
        ExtDevicePrebid extDevicePrebid = extDevice != null ? extDevice.getPrebid() : null;
        return extDevicePrebid != null ? extDevicePrebid.getInterstitial() : null;
    }

    private static class InterstitialSize {
        private static final List<InterstitialSize> INTERSTITIAL_SIZES = new ArrayList<InterstitialSize>();
        private final Integer w;
        private final Integer h;

        private InterstitialSize(Integer w, Integer h) {
            this.w = w;
            this.h = h;
        }

        private static InterstitialSize interstitialSize(Integer w, Integer h) {
            return new InterstitialSize(w, h);
        }

        private static List<InterstitialSize> getNestedSizes(double minWidth, double minHeight, double maxWidth, double maxHeight, int count) {
            return INTERSTITIAL_SIZES.stream().filter(size -> InterstitialSize.isNested(size, minWidth, minHeight, maxWidth, maxHeight)).limit(count).toList();
        }

        private static boolean isNested(InterstitialSize size, double minWidth, double minHeight, double maxWidth, double maxHeight) {
            return (double)size.w.intValue() >= minWidth && (double)size.w.intValue() <= maxWidth && (double)size.h.intValue() >= minHeight && (double)size.h.intValue() <= maxHeight;
        }

        static {
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(160, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(2000, 1400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1920, 1200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1800, 1000));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1920, 1080));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1600, 1150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1696, 900));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1600, 900));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1270, 800));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 1000));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1920, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 320));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1600, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(768, 1024));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1024, 768));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(828, 910));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 970));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(120, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 960));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(620, 891));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(930, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 552));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1272, 328));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(500, 1000));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(900, 550));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(800, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(336, 280));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1250, 360));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(580, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 415));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 820));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(620, 620));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1800, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 310));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(720, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1295, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 1050));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1272, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(580, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1000, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1250, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 1000));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 410));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(800, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(950, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(994, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(940, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 320));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(930, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(250, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(491, 555));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(550, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(750, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1000, 260));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(350, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 210));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 360));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(580, 415));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(750, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(360, 640));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(624, 368));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(900, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(608, 226));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(690, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(605, 340));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 640));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(450, 450));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 480));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(250, 800));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 160));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(950, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(740, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(336, 544));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(303, 603));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 568));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(301, 601));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 601));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(180, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 120));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(950, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(935, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(994, 170));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 360));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(316, 513));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(630, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 320));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 481));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(520, 290));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(250, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 500));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1000, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 460));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(800, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(482, 282));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(680, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 416));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 280));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 431));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 430));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(180, 701));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(840, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(768, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(200, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(350, 350));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(202, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(400, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(414, 286));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(656, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(994, 118));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(638, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(650, 170));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1000, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 360));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(240, 400));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(161, 601));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(610, 138));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(164, 601));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(250, 360));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(605, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(980, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(750, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(150, 600));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(630, 140));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(696, 120));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(307, 254));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(303, 253));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(703, 110));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(550, 140));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 251));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(298, 250));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(500, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(413, 180));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(269, 269));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 106));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(768, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(728, 93));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(729, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(727, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(640, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(720, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(970, 66));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 110));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(707, 83));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(900, 65));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(467, 120));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(200, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(450, 121));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 170));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 169));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(500, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(990, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(140, 350));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(160, 300));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 158));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(190, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(180, 150));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 145));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(310, 122));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(468, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(594, 70));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 80));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(600, 65));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(484, 80));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 75));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(335, 100));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(375, 80));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 75));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(120, 240));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(480, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(120, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(100, 200));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 80));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(160, 160));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(400, 63));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 81));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(1, 1));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 80));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(375, 58));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(232, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(321, 51));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(320, 63));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(319, 49));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 65));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(360, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(125, 125));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(298, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(300, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(299, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(301, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(234, 60));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(280, 47));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(120, 90));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(13, 13));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(17, 17));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(168, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(140, 50));
            INTERSTITIAL_SIZES.add(InterstitialSize.interstitialSize(120, 20));
        }
    }
}

