/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.BidderCatalog;

public class BidderAliases {
    private final Map<String, String> aliasToBidder;
    private final Map<String, Integer> aliasToVendorId;
    private final BidderCatalog bidderCatalog;

    private BidderAliases(Map<String, String> aliasToBidder, Map<String, Integer> aliasToVendorId, BidderCatalog bidderCatalog) {
        this.aliasToBidder = MapUtils.emptyIfNull(aliasToBidder);
        this.aliasToVendorId = MapUtils.emptyIfNull(aliasToVendorId);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
    }

    public static BidderAliases of(Map<String, String> aliasToBidder, Map<String, Integer> aliasToVendorId, BidderCatalog bidderCatalog) {
        return new BidderAliases(aliasToBidder, aliasToVendorId, bidderCatalog);
    }

    public boolean isAliasDefined(String alias) {
        return this.aliasToBidder.containsKey(alias);
    }

    public String resolveBidder(String aliasOrBidder) {
        return this.aliasToBidder.getOrDefault(aliasOrBidder, aliasOrBidder);
    }

    public boolean isSame(String bidder1, String bidder2) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.resolveBidder(bidder1), (CharSequence)this.resolveBidder(bidder2));
    }

    public Integer resolveAliasVendorId(String alias) {
        return this.aliasToVendorId.containsKey(alias) ? this.aliasToVendorId.get(alias) : this.resolveAliasVendorIdViaCatalog(alias);
    }

    private Integer resolveAliasVendorIdViaCatalog(String alias) {
        String bidderName = this.resolveBidder(alias);
        return this.bidderCatalog.isActive(bidderName) ? this.bidderCatalog.vendorIdByName(bidderName) : null;
    }
}

