/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GeoActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GpcActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.AbstractMatchRule;

public final class GeoRule
extends AbstractMatchRule
implements Loggable {
    private final Set<ComponentType> componentTypes;
    private final Set<String> componentNames;
    private final boolean sidsMatched;
    private final List<GeoCode> geoCodes;
    private final String gpc;
    private final boolean allowed;

    public GeoRule(Set<ComponentType> componentTypes, Set<String> componentNames, boolean sidsMatched, List<GeoCode> geoCodes, String gpc, boolean allowed) {
        this.componentTypes = componentTypes;
        this.componentNames = componentNames;
        this.sidsMatched = sidsMatched;
        this.geoCodes = geoCodes;
        this.gpc = gpc;
        this.allowed = allowed;
    }

    @Override
    public boolean matches(ActivityInvocationPayload activityInvocationPayload) {
        return !(!this.sidsMatched || this.geoCodes != null && !this.matchesOneOfGeoCodes(activityInvocationPayload) || this.gpc != null && !this.matchesGpc(activityInvocationPayload) || this.componentTypes != null && !this.componentTypes.contains((Object)activityInvocationPayload.componentType()) || this.componentNames != null && !this.componentNames.contains(activityInvocationPayload.componentName()));
    }

    private boolean matchesOneOfGeoCodes(ActivityInvocationPayload activityInvocationPayload) {
        if (activityInvocationPayload instanceof GeoActivityInvocationPayload) {
            GeoActivityInvocationPayload geoPayload = (GeoActivityInvocationPayload)activityInvocationPayload;
            return this.geoCodes.stream().anyMatch(geoCode -> GeoRule.matchesGeoCode(geoCode, geoPayload));
        }
        return true;
    }

    private static boolean matchesGeoCode(GeoCode geoCode, GeoActivityInvocationPayload geoPayload) {
        String region = geoCode.getRegion();
        return StringUtils.equalsIgnoreCase((CharSequence)geoCode.getCountry(), (CharSequence)geoPayload.country()) && (region == null || StringUtils.equalsIgnoreCase((CharSequence)region, (CharSequence)geoPayload.region()));
    }

    private boolean matchesGpc(ActivityInvocationPayload activityInvocationPayload) {
        if (activityInvocationPayload instanceof GpcActivityInvocationPayload) {
            GpcActivityInvocationPayload gpcActivityInvocationPayload = (GpcActivityInvocationPayload)activityInvocationPayload;
            return this.gpc.equals(gpcActivityInvocationPayload.gpc());
        }
        return true;
    }

    @Override
    public boolean allowed() {
        return this.allowed;
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return mapper.valueToTree((Object)new GeoRuleLogEntry(this.componentTypes, this.componentNames, this.sidsMatched, this.geoCodes, this.gpc, this.allowed));
    }

    public static final class GeoCode {
        private final String country;
        private final String region;

        @ConstructorProperties(value={"country", "region"})
        private GeoCode(String country, String region) {
            this.country = country;
            this.region = region;
        }

        public static GeoCode of(String country, String region) {
            return new GeoCode(country, region);
        }

        public String getCountry() {
            return this.country;
        }

        public String getRegion() {
            return this.region;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeoCode)) {
                return false;
            }
            GeoCode other = (GeoCode)o;
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }

        public String toString() {
            return "GeoRule.GeoCode(country=" + this.getCountry() + ", region=" + this.getRegion() + ")";
        }
    }

    private record GeoRuleLogEntry(Set<ComponentType> componentTypes, Set<String> componentNames, boolean gppSidsMatched, List<GeoCode> geoCodes, String gpc, boolean allow) {
    }
}

