/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.debug.ActivityDebugUtils;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.Rule;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityInfrastructure;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityInvocation;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityInvocationDefaultResult;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityInvocationResult;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityRule;

public class ActivityInfrastructureDebug {
    private final String accountId;
    private final TraceLevel traceLevel;
    private final List<ExtTraceActivityInfrastructure> traceLog;
    private final Metrics metrics;
    private final JacksonMapper jacksonMapper;

    public ActivityInfrastructureDebug(String accountId, TraceLevel traceLevel, Metrics metrics, JacksonMapper jacksonMapper) {
        this.accountId = accountId;
        this.traceLevel = traceLevel;
        this.traceLog = new ArrayList<ExtTraceActivityInfrastructure>();
        this.metrics = Objects.requireNonNull(metrics);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
    }

    public void emitActivityInvocation(Activity activity, ActivityInvocationPayload activityInvocationPayload) {
        if (this.atLeast(TraceLevel.basic)) {
            this.traceLog.add(ExtTraceActivityInvocation.of("Invocation of Activity Infrastructure.", activity, activityInvocationPayload));
        }
    }

    public void emitActivityInvocationDefaultResult(boolean defaultResult) {
        if (this.atLeast(TraceLevel.basic)) {
            this.traceLog.add(ExtTraceActivityInvocationDefaultResult.of("Setting the default invocation result.", defaultResult));
        }
    }

    public void emitProcessedRule(Rule rule, Rule.Result result) {
        if (this.atLeast(TraceLevel.basic)) {
            this.traceLog.add(ExtTraceActivityRule.of("Processing rule.", this.atLeast(TraceLevel.verbose) ? ActivityDebugUtils.asLogEntry(rule, this.jacksonMapper.mapper()) : null, result));
        }
        this.metrics.updateRequestsActivityProcessedRulesCount();
        if (this.atLeast(TraceLevel.verbose)) {
            this.metrics.updateAccountActivityProcessedRulesCount(this.accountId);
        }
    }

    public void emitActivityInvocationResult(Activity activity, ActivityInvocationPayload activityInvocationPayload, boolean result) {
        if (this.atLeast(TraceLevel.basic)) {
            this.traceLog.add(ExtTraceActivityInvocationResult.of("Activity Infrastructure invocation result.", activity, result));
        }
        if (!result) {
            this.metrics.updateRequestsActivityDisallowedCount(activity);
            if (this.atLeast(TraceLevel.verbose)) {
                this.metrics.updateAccountActivityDisallowedCount(this.accountId, activity);
            }
            if (activityInvocationPayload.componentType() == ComponentType.BIDDER) {
                this.metrics.updateAdapterActivityDisallowedCount(activityInvocationPayload.componentName(), activity);
            }
        }
    }

    public List<ExtTraceActivityInfrastructure> trace() {
        return Collections.unmodifiableList(this.traceLog);
    }

    private boolean atLeast(TraceLevel minTraceLevel) {
        return this.traceLevel != null && this.traceLevel.ordinal() >= minTraceLevel.ordinal();
    }
}

