/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.debug;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import org.prebid.server.activity.infrastructure.debug.Loggable;

public class ActivityDebugUtils {
    private ActivityDebugUtils() {
    }

    public static JsonNode asLogEntry(Object object, ObjectMapper mapper) {
        TextNode textNode;
        if (object instanceof Loggable) {
            Loggable loggable = (Loggable)object;
            textNode = loggable.asLogEntry(mapper);
        } else {
            textNode = TextNode.valueOf((String)object.toString());
        }
        return textNode;
    }

    public static ArrayNode asLogEntry(List<?> objects, ObjectMapper mapper) {
        ArrayNode arrayNode = mapper.createArrayNode();
        objects.stream().map(object -> ActivityDebugUtils.asLogEntry(object, mapper)).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }
}

