/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.creator.ActivityControllerCreationContext;
import org.prebid.server.activity.infrastructure.creator.rule.AbstractRuleCreator;
import org.prebid.server.activity.infrastructure.rule.GeoRule;
import org.prebid.server.activity.infrastructure.rule.Rule;
import org.prebid.server.settings.model.activity.rule.AccountActivityGeoRuleConfig;

public class GeoRuleCreator
extends AbstractRuleCreator<AccountActivityGeoRuleConfig> {
    public GeoRuleCreator() {
        super(AccountActivityGeoRuleConfig.class);
    }

    @Override
    protected Rule fromConfiguration(AccountActivityGeoRuleConfig ruleConfiguration, ActivityControllerCreationContext creationContext) {
        boolean allow = GeoRuleCreator.allowFromConfig(ruleConfiguration.getAllow());
        AccountActivityGeoRuleConfig.Condition condition = ruleConfiguration.getCondition();
        return new GeoRule(condition != null ? GeoRuleCreator.setOf(condition.getComponentTypes()) : null, condition != null ? GeoRuleCreator.caseInsensitiveSetOf(condition.getComponentNames()) : null, GeoRuleCreator.sidsMatched(condition, creationContext.getGppContext().scope().getSectionsIds()), condition != null ? GeoRuleCreator.geoCodes(condition.getGeoCodes()) : null, condition != null ? condition.getGpc() : null, allow);
    }

    private static boolean allowFromConfig(Boolean configValue) {
        return configValue != null ? configValue : true;
    }

    private static Set<ComponentType> setOf(Collection<ComponentType> collection) {
        return collection != null ? new HashSet<ComponentType>(collection) : null;
    }

    private static Set<String> caseInsensitiveSetOf(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        TreeSet<String> caseInsensitiveSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveSet.addAll(collection);
        return caseInsensitiveSet;
    }

    private static boolean sidsMatched(AccountActivityGeoRuleConfig.Condition condition, Set<Integer> gppSids) {
        List<Integer> sids = condition != null ? condition.getSids() : null;
        return sids == null || GeoRuleCreator.intersects(sids, gppSids);
    }

    private static boolean intersects(Collection<Integer> configurationSids, Collection<Integer> gppSids) {
        return CollectionUtils.isNotEmpty(configurationSids) && CollectionUtils.isNotEmpty(gppSids) && !CollectionUtils.intersection(configurationSids, gppSids).isEmpty();
    }

    private static List<GeoRule.GeoCode> geoCodes(List<String> stringGeoCodes) {
        return stringGeoCodes != null ? stringGeoCodes.stream().map(GeoRuleCreator::from).filter(Objects::nonNull).toList() : null;
    }

    private static GeoRule.GeoCode from(String stringGeoCode) {
        if (StringUtils.isBlank((CharSequence)stringGeoCode)) {
            return null;
        }
        int firstDot = stringGeoCode.indexOf(".");
        if (firstDot == -1) {
            return GeoRule.GeoCode.of(stringGeoCode, null);
        }
        if (firstDot == stringGeoCode.length() - 1) {
            return GeoRule.GeoCode.of(stringGeoCode.substring(0, firstDot), null);
        }
        return GeoRule.GeoCode.of(stringGeoCode.substring(0, firstDot), stringGeoCode.substring(firstDot + 1));
    }
}

