/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.activity.infrastructure.creator.ActivityControllerCreationContext;
import org.prebid.server.activity.infrastructure.creator.rule.RuleCreator;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class ActivityRuleFactory {
    private final Map<Class<?>, RuleCreator<?>> ruleCreators;

    public ActivityRuleFactory(List<RuleCreator<?>> ruleCreators) {
        this.ruleCreators = CollectionUtils.emptyIfNull(ruleCreators).stream().collect(Collectors.toMap(RuleCreator::relatedConfigurationClass, Function.identity()));
    }

    public Rule from(Object ruleConfiguration, ActivityControllerCreationContext activityControllerCreationContext) {
        Class<?> ruleConfigurationClass = ruleConfiguration.getClass();
        RuleCreator<?> ruleCreator = this.ruleCreators.get(ruleConfigurationClass);
        if (ruleCreator == null) {
            throw new IllegalStateException("Rule creator for %s not found.".formatted(ruleConfigurationClass));
        }
        return ruleCreator.from(ruleConfiguration, activityControllerCreationContext);
    }
}

