/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.infrastructure.ActivityController;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.creator.ActivityControllerCreationContext;
import org.prebid.server.activity.infrastructure.creator.ActivityRuleFactory;
import org.prebid.server.activity.infrastructure.debug.ActivityInfrastructureDebug;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModuleQualifier;
import org.prebid.server.activity.infrastructure.rule.Rule;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountPrivacyConfig;
import org.prebid.server.settings.model.activity.AccountActivityConfiguration;
import org.prebid.server.settings.model.activity.privacy.AccountPrivacyModuleConfig;

public class ActivityInfrastructureCreator {
    private static final Logger logger = LoggerFactory.getLogger(ActivityInfrastructureCreator.class);
    private final ActivityRuleFactory activityRuleFactory;
    private final Metrics metrics;
    private final JacksonMapper jacksonMapper;

    public ActivityInfrastructureCreator(ActivityRuleFactory activityRuleFactory, Metrics metrics, JacksonMapper jacksonMapper) {
        this.activityRuleFactory = Objects.requireNonNull(activityRuleFactory);
        this.metrics = Objects.requireNonNull(metrics);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
    }

    public ActivityInfrastructure create(Account account, GppContext gppContext, TraceLevel traceLevel) {
        ActivityInfrastructureDebug debug = this.debugWheel(account, traceLevel);
        return new ActivityInfrastructure(this.parse(account, gppContext, debug), debug);
    }

    private ActivityInfrastructureDebug debugWheel(Account account, TraceLevel traceLevel) {
        return new ActivityInfrastructureDebug(account.getId(), traceLevel, this.metrics, this.jacksonMapper);
    }

    Map<Activity, ActivityController> parse(Account account, GppContext gppContext, ActivityInfrastructureDebug debug) {
        Optional<AccountPrivacyConfig> accountPrivacyConfig = Optional.ofNullable(account.getPrivacy());
        Map activitiesConfiguration = accountPrivacyConfig.map(AccountPrivacyConfig::getActivities).orElseGet(Collections::emptyMap);
        Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> modulesConfigs = accountPrivacyConfig.map(AccountPrivacyConfig::getModules).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(AccountPrivacyModuleConfig::getCode, UnaryOperator.identity(), this.takeFirstAndLogDuplicates(account.getId())));
        return Arrays.stream(Activity.values()).collect(Collectors.toMap(UnaryOperator.identity(), activity -> this.from((Activity)((Object)activity), (AccountActivityConfiguration)activitiesConfiguration.get(activity), modulesConfigs, gppContext, debug), (oldValue, newValue) -> oldValue, ActivityInfrastructureCreator.enumMapFactory()));
    }

    private BinaryOperator<AccountPrivacyModuleConfig> takeFirstAndLogDuplicates(String accountId) {
        return (first, second) -> {
            logger.warn((Object)"Duplicate configuration found for privacy module %s for account %s".formatted(new Object[]{second.getCode(), accountId}));
            this.metrics.updateAlertsMetrics(MetricName.general);
            return first;
        };
    }

    private ActivityController from(Activity activity, AccountActivityConfiguration activityConfiguration, Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> modulesConfigs, GppContext gppContext, ActivityInfrastructureDebug debug) {
        if (activityConfiguration == null) {
            return ActivityController.of(true, Collections.emptyList(), debug);
        }
        ActivityControllerCreationContext creationContext = ActivityControllerCreationContext.of(activity, modulesConfigs, gppContext);
        boolean allow = ActivityInfrastructureCreator.allowFromConfig(activityConfiguration.getAllow());
        List<Rule> rules = ListUtils.emptyIfNull(activityConfiguration.getRules()).stream().filter(Objects::nonNull).map(ruleConfiguration -> this.activityRuleFactory.from(ruleConfiguration, creationContext)).toList();
        return ActivityController.of(allow, rules, debug);
    }

    private static boolean allowFromConfig(Boolean configValue) {
        return configValue != null ? configValue : true;
    }

    private static Supplier<Map<Activity, ActivityController>> enumMapFactory() {
        return () -> new EnumMap(Activity.class);
    }
}

