/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator;

import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModuleQualifier;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.settings.model.activity.privacy.AccountPrivacyModuleConfig;

public final class ActivityControllerCreationContext {
    private final Activity activity;
    private final Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> privacyModulesConfigs;
    private final Set<PrivacyModuleQualifier> usedPrivacyModules = EnumSet.noneOf(PrivacyModuleQualifier.class);
    private final GppContext gppContext;

    public boolean isUsed(PrivacyModuleQualifier qualifier) {
        return this.usedPrivacyModules.contains((Object)qualifier);
    }

    public void use(PrivacyModuleQualifier qualifier) {
        this.usedPrivacyModules.add(qualifier);
    }

    @ConstructorProperties(value={"activity", "privacyModulesConfigs", "gppContext"})
    private ActivityControllerCreationContext(Activity activity, Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> privacyModulesConfigs, GppContext gppContext) {
        this.activity = activity;
        this.privacyModulesConfigs = privacyModulesConfigs;
        this.gppContext = gppContext;
    }

    public static ActivityControllerCreationContext of(Activity activity, Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> privacyModulesConfigs, GppContext gppContext) {
        return new ActivityControllerCreationContext(activity, privacyModulesConfigs, gppContext);
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> getPrivacyModulesConfigs() {
        return this.privacyModulesConfigs;
    }

    public GppContext getGppContext() {
        return this.gppContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityControllerCreationContext)) {
            return false;
        }
        ActivityControllerCreationContext other = (ActivityControllerCreationContext)o;
        Activity this$activity = this.getActivity();
        Activity other$activity = other.getActivity();
        if (this$activity == null ? other$activity != null : !((Object)((Object)this$activity)).equals((Object)other$activity)) {
            return false;
        }
        Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> this$privacyModulesConfigs = this.getPrivacyModulesConfigs();
        Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> other$privacyModulesConfigs = other.getPrivacyModulesConfigs();
        if (this$privacyModulesConfigs == null ? other$privacyModulesConfigs != null : !((Object)this$privacyModulesConfigs).equals(other$privacyModulesConfigs)) {
            return false;
        }
        Set<PrivacyModuleQualifier> this$usedPrivacyModules = this.usedPrivacyModules;
        Set<PrivacyModuleQualifier> other$usedPrivacyModules = other.usedPrivacyModules;
        if (this$usedPrivacyModules == null ? other$usedPrivacyModules != null : !((Object)this$usedPrivacyModules).equals(other$usedPrivacyModules)) {
            return false;
        }
        GppContext this$gppContext = this.getGppContext();
        GppContext other$gppContext = other.getGppContext();
        return !(this$gppContext == null ? other$gppContext != null : !((Object)this$gppContext).equals(other$gppContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Activity $activity = this.getActivity();
        result = result * 59 + ($activity == null ? 43 : ((Object)((Object)$activity)).hashCode());
        Map<PrivacyModuleQualifier, AccountPrivacyModuleConfig> $privacyModulesConfigs = this.getPrivacyModulesConfigs();
        result = result * 59 + ($privacyModulesConfigs == null ? 43 : ((Object)$privacyModulesConfigs).hashCode());
        Set<PrivacyModuleQualifier> $usedPrivacyModules = this.usedPrivacyModules;
        result = result * 59 + ($usedPrivacyModules == null ? 43 : ((Object)$usedPrivacyModules).hashCode());
        GppContext $gppContext = this.getGppContext();
        result = result * 59 + ($gppContext == null ? 43 : ((Object)$gppContext).hashCode());
        return result;
    }

    public String toString() {
        return "ActivityControllerCreationContext(activity=" + this.getActivity() + ", privacyModulesConfigs=" + this.getPrivacyModulesConfigs() + ", usedPrivacyModules=" + this.usedPrivacyModules + ", gppContext=" + this.getGppContext() + ")";
    }
}

