/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx.http;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class BasicHttpClient
implements HttpClient {
    private final Vertx vertx;
    private final io.vertx.core.http.HttpClient httpClient;

    public BasicHttpClient(Vertx vertx, io.vertx.core.http.HttpClient httpClient) {
        this.vertx = Objects.requireNonNull(vertx);
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    public Future<HttpClientResponse> request(HttpMethod method, String url, MultiMap headers, String body, long timeoutMs, long maxResponseSize) {
        return this.request(method, url, headers, timeoutMs, maxResponseSize, (Object)body, httpClientRequest -> httpClientRequest.end(body));
    }

    public Future<HttpClientResponse> request(HttpMethod method, String url, MultiMap headers, byte[] body, long timeoutMs, long maxResponseSize) {
        return this.request(method, url, headers, timeoutMs, maxResponseSize, (Object)body, httpClientRequest -> httpClientRequest.end(Buffer.buffer((byte[])body)));
    }

    private <T> Future<HttpClientResponse> request(HttpMethod method, String url, MultiMap headers, long timeoutMs, long maxResponseSize, T body, Consumer<HttpClientRequest> requestBodySetter) {
        Promise promise = Promise.promise();
        if (timeoutMs <= 0L) {
            BasicHttpClient.failResponse((Throwable)new TimeoutException("Timeout has been exceeded"), (Promise)promise);
        } else {
            HttpClientRequest httpClientRequest;
            try {
                httpClientRequest = this.httpClient.requestAbs(method, url);
            }
            catch (Exception e) {
                BasicHttpClient.failResponse((Throwable)e, (Promise)promise);
                return promise.future();
            }
            long timerId = this.vertx.setTimer(timeoutMs, id -> this.handleTimeout(promise, timeoutMs, httpClientRequest));
            httpClientRequest.setFollowRedirects(true).handler(response -> this.handleResponse(response, promise, timerId, maxResponseSize)).exceptionHandler(exception -> this.failResponse(exception, promise, timerId));
            if (headers != null) {
                httpClientRequest.headers().addAll(headers);
            }
            if (body != null) {
                requestBodySetter.accept(httpClientRequest);
            } else {
                httpClientRequest.end();
            }
        }
        return promise.future();
    }

    private void handleTimeout(Promise<HttpClientResponse> promise, long timeoutMs, HttpClientRequest httpClientRequest) {
        if (!promise.future().isComplete()) {
            BasicHttpClient.failResponse((Throwable)new TimeoutException("Timeout period of %dms has been exceeded".formatted(timeoutMs)), promise);
            httpClientRequest.reset();
        }
    }

    private void handleResponse(io.vertx.core.http.HttpClientResponse response, Promise<HttpClientResponse> promise, long timerId, long maxResponseSize) {
        long responseBodySize;
        String contentLength = response.getHeader(HttpHeaders.CONTENT_LENGTH);
        long l = responseBodySize = contentLength != null ? Long.parseLong(contentLength) : 0L;
        if (responseBodySize > maxResponseSize) {
            this.failResponse((Throwable)new PreBidException("Response size %d exceeded %d bytes limit".formatted(responseBodySize, maxResponseSize)), promise, timerId);
            return;
        }
        response.bodyHandler(buffer -> this.successResponse(buffer.toString(), response, promise, timerId)).exceptionHandler(exception -> this.failResponse(exception, promise, timerId));
    }

    private void successResponse(String body, io.vertx.core.http.HttpClientResponse response, Promise<HttpClientResponse> promise, long timerId) {
        this.vertx.cancelTimer(timerId);
        promise.tryComplete((Object)HttpClientResponse.of((int)response.statusCode(), (MultiMap)response.headers(), (String)body));
    }

    private void failResponse(Throwable exception, Promise<HttpClientResponse> promise, long timerId) {
        this.vertx.cancelTimer(timerId);
        BasicHttpClient.failResponse((Throwable)exception, promise);
    }

    private static void failResponse(Throwable exception, Promise<HttpClientResponse> promise) {
        promise.tryFail(exception);
    }
}

