/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.ResourceUtil;
import org.prebid.server.util.VersionInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public final class VersionInfo {
    private static final Logger logger = LoggerFactory.getLogger(VersionInfo.class);
    private static final String UNDEFINED = "undefined";
    private final String version;
    private final String commitHash;

    private VersionInfo(String version, String commitHash) {
        this.version = version;
        this.commitHash = commitHash;
    }

    public static VersionInfo create(String revisionFilePath, JacksonMapper jacksonMapper) {
        Revision revision;
        try {
            revision = (Revision)jacksonMapper.mapper().readValue(ResourceUtil.readFromClasspath((String)revisionFilePath), Revision.class);
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error((Object)"Was not able to read revision file {0}. Reason: {1}", new Object[]{revisionFilePath, e.getMessage()});
            return new VersionInfo("undefined", "undefined");
        }
        String pbsVersion = revision.getPbsVersion();
        String commitHash = revision.getCommitHash();
        return new VersionInfo(pbsVersion != null ? VersionInfo.extractVersion((String)pbsVersion) : "undefined", commitHash != null ? commitHash : "undefined");
    }

    private static String extractVersion(String buildVersion) {
        Pattern versionPattern = Pattern.compile("\\d+\\.\\d+\\.\\d");
        Matcher versionMatcher = versionPattern.matcher(buildVersion);
        return versionMatcher.lookingAt() ? versionMatcher.group() : null;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$commitHash = this.getCommitHash();
        String other$commitHash = other.getCommitHash();
        return !(this$commitHash == null ? other$commitHash != null : !this$commitHash.equals(other$commitHash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $commitHash = this.getCommitHash();
        result = result * 59 + ($commitHash == null ? 43 : $commitHash.hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfo(version=" + this.getVersion() + ", commitHash=" + this.getCommitHash() + ")";
    }
}

