/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.server;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.Router;
import javax.annotation.PostConstruct;
import org.prebid.server.handler.ExceptionHandler;
import org.prebid.server.vertx.ContextRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"server.unix-socket.enabled"}, havingValue="true")
public class UnixSocketServerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(UnixSocketServerConfiguration.class);
    @Autowired
    private ContextRunner contextRunner;
    @Autowired
    private Vertx vertx;
    @Autowired
    private HttpServerOptions httpServerOptions;
    @Autowired
    private ExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier(value="router")
    private Router router;
    @Value(value="${server.unix-socket.path}")
    private String socketPath;
    @Value(value="${server.unix-socket.server-instances}")
    private Integer serverNum;

    @PostConstruct
    public void startUnixSocketServer() {
        logger.info((Object)"Starting {0} instances of Unix Socket Server to serve requests on socket {1}", new Object[]{this.serverNum, this.socketPath});
        this.contextRunner.runOnNewContext(this.serverNum.intValue(), promise -> this.vertx.createHttpServer(this.httpServerOptions).exceptionHandler((Handler)this.exceptionHandler).requestHandler((Handler)this.router).listen(SocketAddress.domainSocketAddress((String)this.socketPath), (Handler)promise));
        logger.info((Object)"Successfully started {0} instances of Unix Socket Server", new Object[]{this.serverNum});
    }
}

