/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder.model;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.spring.config.bidder.model.CompressionType;
import org.prebid.server.spring.config.bidder.model.Debug;
import org.prebid.server.spring.config.bidder.model.DefaultBidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.model.MetaInfo;
import org.prebid.server.spring.config.bidder.model.usersync.UsersyncConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;

@Validated
public class BidderConfigurationProperties {
    @Autowired
    DefaultBidderConfigurationProperties defaultProperties;
    private Boolean enabled;
    private OrtbVersion ortbVersion;
    @NotBlank
    private String endpoint;
    private Boolean pbsEnforcesCcpa;
    private Boolean modifyingVastXmlAllowed;
    private List<String> deprecatedNames;
    private Map<String, Object> aliases;
    private Debug debug;
    @NotNull
    private MetaInfo metaInfo;
    private UsersyncConfigurationProperties usersync;
    private CompressionType endpointCompression;
    private final Class<? extends BidderConfigurationProperties> selfClass = this.getClass();

    @PostConstruct
    private void init() {
        this.enabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enabled, (Object)this.defaultProperties.getEnabled());
        this.ortbVersion = (OrtbVersion)ObjectUtils.defaultIfNull((Object)this.ortbVersion, (Object)this.defaultProperties.getOrtbVersion());
        this.pbsEnforcesCcpa = (Boolean)ObjectUtils.defaultIfNull((Object)this.pbsEnforcesCcpa, (Object)this.defaultProperties.getPbsEnforcesCcpa());
        this.modifyingVastXmlAllowed = (Boolean)ObjectUtils.defaultIfNull((Object)this.modifyingVastXmlAllowed, (Object)this.defaultProperties.getModifyingVastXmlAllowed());
        this.debug = (Debug)ObjectUtils.defaultIfNull((Object)this.debug, (Object)this.defaultProperties.getDebug());
        this.aliases = (Map)ObjectUtils.defaultIfNull((Object)this.aliases, (Object)this.defaultProperties.getAliases());
        this.deprecatedNames = (List)ObjectUtils.defaultIfNull((Object)this.deprecatedNames, (Object)this.defaultProperties.getDeprecatedNames());
        this.endpointCompression = (CompressionType)ObjectUtils.defaultIfNull((Object)this.endpointCompression, (Object)this.defaultProperties.getEndpointCompression());
        if (this.usersync != null && this.usersync.getEnabled() == null) {
            this.usersync.setEnabled(Boolean.valueOf(true));
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public OrtbVersion getOrtbVersion() {
        return this.ortbVersion;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Boolean getPbsEnforcesCcpa() {
        return this.pbsEnforcesCcpa;
    }

    public Boolean getModifyingVastXmlAllowed() {
        return this.modifyingVastXmlAllowed;
    }

    public List<String> getDeprecatedNames() {
        return this.deprecatedNames;
    }

    public Map<String, Object> getAliases() {
        return this.aliases;
    }

    public Debug getDebug() {
        return this.debug;
    }

    @NotNull
    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public UsersyncConfigurationProperties getUsersync() {
        return this.usersync;
    }

    public CompressionType getEndpointCompression() {
        return this.endpointCompression;
    }

    public Class<? extends BidderConfigurationProperties> getSelfClass() {
        return this.selfClass;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setOrtbVersion(OrtbVersion ortbVersion) {
        this.ortbVersion = ortbVersion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPbsEnforcesCcpa(Boolean pbsEnforcesCcpa) {
        this.pbsEnforcesCcpa = pbsEnforcesCcpa;
    }

    public void setModifyingVastXmlAllowed(Boolean modifyingVastXmlAllowed) {
        this.modifyingVastXmlAllowed = modifyingVastXmlAllowed;
    }

    public void setDeprecatedNames(List<String> deprecatedNames) {
        this.deprecatedNames = deprecatedNames;
    }

    public void setAliases(Map<String, Object> aliases) {
        this.aliases = aliases;
    }

    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    public void setMetaInfo(@NotNull MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setUsersync(UsersyncConfigurationProperties usersync) {
        this.usersync = usersync;
    }

    public void setEndpointCompression(CompressionType endpointCompression) {
        this.endpointCompression = endpointCompression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderConfigurationProperties)) {
            return false;
        }
        BidderConfigurationProperties other = (BidderConfigurationProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$pbsEnforcesCcpa = this.getPbsEnforcesCcpa();
        Boolean other$pbsEnforcesCcpa = other.getPbsEnforcesCcpa();
        if (this$pbsEnforcesCcpa == null ? other$pbsEnforcesCcpa != null : !((Object)this$pbsEnforcesCcpa).equals(other$pbsEnforcesCcpa)) {
            return false;
        }
        Boolean this$modifyingVastXmlAllowed = this.getModifyingVastXmlAllowed();
        Boolean other$modifyingVastXmlAllowed = other.getModifyingVastXmlAllowed();
        if (this$modifyingVastXmlAllowed == null ? other$modifyingVastXmlAllowed != null : !((Object)this$modifyingVastXmlAllowed).equals(other$modifyingVastXmlAllowed)) {
            return false;
        }
        DefaultBidderConfigurationProperties this$defaultProperties = this.defaultProperties;
        DefaultBidderConfigurationProperties other$defaultProperties = other.defaultProperties;
        if (this$defaultProperties == null ? other$defaultProperties != null : !this$defaultProperties.equals(other$defaultProperties)) {
            return false;
        }
        OrtbVersion this$ortbVersion = this.getOrtbVersion();
        OrtbVersion other$ortbVersion = other.getOrtbVersion();
        if (this$ortbVersion == null ? other$ortbVersion != null : !this$ortbVersion.equals(other$ortbVersion)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        List this$deprecatedNames = this.getDeprecatedNames();
        List other$deprecatedNames = other.getDeprecatedNames();
        if (this$deprecatedNames == null ? other$deprecatedNames != null : !((Object)this$deprecatedNames).equals(other$deprecatedNames)) {
            return false;
        }
        Map this$aliases = this.getAliases();
        Map other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Debug this$debug = this.getDebug();
        Debug other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !this$metaInfo.equals(other$metaInfo)) {
            return false;
        }
        UsersyncConfigurationProperties this$usersync = this.getUsersync();
        UsersyncConfigurationProperties other$usersync = other.getUsersync();
        if (this$usersync == null ? other$usersync != null : !this$usersync.equals(other$usersync)) {
            return false;
        }
        CompressionType this$endpointCompression = this.getEndpointCompression();
        CompressionType other$endpointCompression = other.getEndpointCompression();
        if (this$endpointCompression == null ? other$endpointCompression != null : !this$endpointCompression.equals(other$endpointCompression)) {
            return false;
        }
        Class this$selfClass = this.getSelfClass();
        Class other$selfClass = other.getSelfClass();
        return !(this$selfClass == null ? other$selfClass != null : !this$selfClass.equals(other$selfClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BidderConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $pbsEnforcesCcpa = this.getPbsEnforcesCcpa();
        result = result * 59 + ($pbsEnforcesCcpa == null ? 43 : ((Object)$pbsEnforcesCcpa).hashCode());
        Boolean $modifyingVastXmlAllowed = this.getModifyingVastXmlAllowed();
        result = result * 59 + ($modifyingVastXmlAllowed == null ? 43 : ((Object)$modifyingVastXmlAllowed).hashCode());
        DefaultBidderConfigurationProperties $defaultProperties = this.defaultProperties;
        result = result * 59 + ($defaultProperties == null ? 43 : $defaultProperties.hashCode());
        OrtbVersion $ortbVersion = this.getOrtbVersion();
        result = result * 59 + ($ortbVersion == null ? 43 : $ortbVersion.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        List $deprecatedNames = this.getDeprecatedNames();
        result = result * 59 + ($deprecatedNames == null ? 43 : ((Object)$deprecatedNames).hashCode());
        Map $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Debug $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : $metaInfo.hashCode());
        UsersyncConfigurationProperties $usersync = this.getUsersync();
        result = result * 59 + ($usersync == null ? 43 : $usersync.hashCode());
        CompressionType $endpointCompression = this.getEndpointCompression();
        result = result * 59 + ($endpointCompression == null ? 43 : $endpointCompression.hashCode());
        Class $selfClass = this.getSelfClass();
        result = result * 59 + ($selfClass == null ? 43 : $selfClass.hashCode());
        return result;
    }

    public String toString() {
        return "BidderConfigurationProperties(defaultProperties=" + this.defaultProperties + ", enabled=" + this.getEnabled() + ", ortbVersion=" + this.getOrtbVersion() + ", endpoint=" + this.getEndpoint() + ", pbsEnforcesCcpa=" + this.getPbsEnforcesCcpa() + ", modifyingVastXmlAllowed=" + this.getModifyingVastXmlAllowed() + ", deprecatedNames=" + this.getDeprecatedNames() + ", aliases=" + this.getAliases() + ", debug=" + this.getDebug() + ", metaInfo=" + this.getMetaInfo() + ", usersync=" + this.getUsersync() + ", endpointCompression=" + this.getEndpointCompression() + ", selfClass=" + this.getSelfClass() + ")";
    }
}

