/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.rubicon.RubiconBidder;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.floors.PriceFloorResolver;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.RubiconConfiguration;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/rubicon.yaml"}, factory=YamlPropertySourceFactory.class)
public class RubiconConfiguration {
    private static final String BIDDER_NAME = "rubicon";

    @Bean(value={"rubiconConfigurationProperties"})
    @ConfigurationProperties(value="adapters.rubicon")
    RubiconConfigurationProperties configurationProperties() {
        return new RubiconConfigurationProperties();
    }

    @Bean
    BidderDeps rubiconBidderDeps(RubiconConfigurationProperties rubiconConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, CurrencyConversionService currencyConversionService, PriceFloorResolver floorResolver, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig((BidderConfigurationProperties)rubiconConfigurationProperties).usersyncerCreator(UsersyncerCreator.create((String)externalUrl)).bidderCreator(config -> new RubiconBidder(config.getEndpoint(), config.getXapi().getUsername(), config.getXapi().getPassword(), config.getMetaInfo().getSupportedVendors(), config.getGenerateBidId().booleanValue(), currencyConversionService, floorResolver, mapper)).assemble();
    }
}

