/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.imds.ImdsBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.prebid.server.version.PrebidVersionProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/imds.yaml"}, factory=YamlPropertySourceFactory.class)
public class ImdsConfiguration {
    private static final String BIDDER_NAME = "imds";

    @Bean(value={"imdsConfigurationProperties"})
    @ConfigurationProperties(value="adapters.imds")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps imdsBidderDeps(BidderConfigurationProperties imdsConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig(imdsConfigurationProperties).usersyncerCreator(UsersyncerCreator.create((String)externalUrl)).bidderCreator(config -> new ImdsBidder(config.getEndpoint(), prebidVersionProvider.getNameVersionRecord(), mapper)).assemble();
    }
}

