/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.time.Clock;
import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.huaweiads.ClientTimeFormatter;
import org.prebid.server.bidder.huaweiads.CountryCodeResolver;
import org.prebid.server.bidder.huaweiads.HuaweiAdSlotBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAdmBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAdsBidder;
import org.prebid.server.bidder.huaweiads.HuaweiAppBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiDeviceBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiEndpointResolver;
import org.prebid.server.bidder.huaweiads.HuaweiNetworkBuilder;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.HuaweiAdsConfiguration;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/huaweiads.yaml"}, factory=YamlPropertySourceFactory.class)
public class HuaweiAdsConfiguration {
    private static final String BIDDER_NAME = "huaweiads";

    @Bean(value={"huaweiadsConfigurationProperties"})
    @ConfigurationProperties(value="adapters.huaweiads")
    HuaweiAdsConfigurationProperties configurationProperties() {
        return new HuaweiAdsConfigurationProperties();
    }

    @Bean
    BidderDeps huaweiAdsBidderDeps(HuaweiAdsConfigurationProperties huaweiadsConfigurationProperties, CountryCodeMapper countryCodeMapper, Clock clock, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig((BidderConfigurationProperties)huaweiadsConfigurationProperties).usersyncerCreator(UsersyncerCreator.create((String)externalUrl)).bidderCreator(config -> {
            ExtraInfo extraInfo = config.getExtraInfo();
            return new HuaweiAdsBidder(mapper, new HuaweiAdSlotBuilder(mapper), new HuaweiAppBuilder(extraInfo.getPkgNameConvert()), new HuaweiDeviceBuilder(mapper, new ClientTimeFormatter(clock)), new HuaweiNetworkBuilder(), new HuaweiAdmBuilder(mapper), new CountryCodeResolver(countryCodeMapper), new HuaweiEndpointResolver(config.getEndpoint(), extraInfo.getChineseEndpoint(), extraInfo.getRussianEndpoint(), extraInfo.getEuropeanEndpoint(), extraInfo.getAsianEndpoint(), extraInfo.getCloseSiteSelectionByCountry()));
        }).assemble();
    }
}

