/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.cpmstar.CpmStarBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/cpmstar.yaml"}, factory=YamlPropertySourceFactory.class)
public class CpmStarConfiguration {
    private static final String BIDDER_NAME = "cpmstar";

    @Bean(value={"cpmstarConfigurationProperties"})
    @ConfigurationProperties(value="adapters.cpmstar")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps cpmstarBidderDeps(BidderConfigurationProperties cpmstarConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig(cpmstarConfigurationProperties).usersyncerCreator(UsersyncerCreator.create((String)externalUrl)).bidderCreator(config -> new CpmStarBidder(config.getEndpoint(), mapper)).assemble();
    }
}

