/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.connectad.ConnectadBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/connectad.yaml"}, factory=YamlPropertySourceFactory.class)
public class ConnectAdConfiguration {
    private static final String BIDDER_NAME = "connectad";

    @Bean(value={"connectadConfigurationProperties"})
    @ConfigurationProperties(value="adapters.connectad")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps connectadBidderDeps(BidderConfigurationProperties connectadConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig(connectadConfigurationProperties).usersyncerCreator(UsersyncerCreator.create((String)externalUrl)).bidderCreator(config -> new ConnectadBidder(config.getEndpoint(), mapper)).assemble();
    }
}

