/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.analytics.reporter.log.LogAnalyticsReporter;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.Metrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AnalyticsConfiguration {
    @Bean
    AnalyticsReporterDelegator analyticsReporterDelegator(@Autowired(required=false) List<AnalyticsReporter> delegates, Vertx vertx, PrivacyEnforcementService privacyEnforcementService, Metrics metrics, @Value(value="${logging.sampling-rate:0.01}") double logSamplingRate) {
        return new AnalyticsReporterDelegator(logSamplingRate, ListUtils.emptyIfNull(delegates), vertx, privacyEnforcementService, metrics);
    }

    @Bean
    @ConditionalOnProperty(prefix="analytics.log", name={"enabled"}, havingValue="true")
    LogAnalyticsReporter logAnalyticsReporter(JacksonMapper mapper) {
        return new LogAnalyticsReporter(mapper);
    }
}

