/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.service;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.CacheNotificationListener;
import org.prebid.server.settings.helper.JdbcStoredDataResultMapper;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.jdbc.JdbcClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcPeriodicRefreshService
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcPeriodicRefreshService.class);
    private final String initQuery;
    private final String updateQuery;
    private final long refreshPeriod;
    private final long timeout;
    private final MetricName cacheType;
    private final CacheNotificationListener cacheNotificationListener;
    private final Vertx vertx;
    private final JdbcClient jdbcClient;
    private final TimeoutFactory timeoutFactory;
    private final Metrics metrics;
    private final Clock clock;
    private Instant lastUpdate;

    public JdbcPeriodicRefreshService(String initQuery, String updateQuery, long refreshPeriod, long timeout, MetricName cacheType, CacheNotificationListener cacheNotificationListener, Vertx vertx, JdbcClient jdbcClient, TimeoutFactory timeoutFactory, Metrics metrics, Clock clock) {
        this.initQuery = Objects.requireNonNull(StringUtils.stripToNull((String)initQuery));
        this.updateQuery = Objects.requireNonNull(StringUtils.stripToNull((String)updateQuery));
        this.refreshPeriod = refreshPeriod;
        this.timeout = timeout;
        this.cacheType = Objects.requireNonNull(cacheType);
        this.cacheNotificationListener = Objects.requireNonNull(cacheNotificationListener);
        this.vertx = Objects.requireNonNull(vertx);
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
    }

    public void initialize() {
        this.getAll();
        if (this.refreshPeriod > 0L) {
            this.vertx.setPeriodic(this.refreshPeriod, aLong -> this.refresh());
        }
    }

    private void getAll() {
        long startTime = this.clock.millis();
        this.jdbcClient.executeQuery(this.initQuery, Collections.emptyList(), JdbcStoredDataResultMapper::map, this.createTimeout()).map(storedDataResult -> this.handleResult(storedDataResult, Instant.now(this.clock), startTime, MetricName.initialize)).recover(exception -> this.handleFailure(exception, startTime, MetricName.initialize));
    }

    private Void handleResult(StoredDataResult storedDataResult, Instant updateTime, long startTime, MetricName refreshType) {
        this.cacheNotificationListener.save(storedDataResult.getStoredIdToRequest(), storedDataResult.getStoredIdToImp());
        this.lastUpdate = updateTime;
        this.metrics.updateSettingsCacheRefreshTime(this.cacheType, refreshType, this.clock.millis() - startTime);
        return null;
    }

    private Future<Void> handleFailure(Throwable exception, long startTime, MetricName refreshType) {
        logger.warn((Object)"Error occurred while request to jdbc refresh service", exception);
        this.metrics.updateSettingsCacheRefreshTime(this.cacheType, refreshType, this.clock.millis() - startTime);
        this.metrics.updateSettingsCacheRefreshErrorMetric(this.cacheType, refreshType);
        return Future.failedFuture((Throwable)exception);
    }

    private void refresh() {
        Instant updateTime = Instant.now(this.clock);
        long startTime = this.clock.millis();
        this.jdbcClient.executeQuery(this.updateQuery, Collections.singletonList(Date.from(this.lastUpdate)), JdbcStoredDataResultMapper::map, this.createTimeout()).map(storedDataResult -> this.handleResult(this.invalidate(storedDataResult), updateTime, startTime, MetricName.update)).recover(exception -> this.handleFailure(exception, startTime, MetricName.update));
    }

    private StoredDataResult invalidate(StoredDataResult storedDataResult) {
        List invalidatedRequests = JdbcPeriodicRefreshService.getInvalidatedKeys((Map)storedDataResult.getStoredIdToRequest());
        List invalidatedImps = JdbcPeriodicRefreshService.getInvalidatedKeys((Map)storedDataResult.getStoredIdToImp());
        if (!invalidatedRequests.isEmpty() || !invalidatedImps.isEmpty()) {
            this.cacheNotificationListener.invalidate(invalidatedRequests, invalidatedImps);
        }
        Map requestsToSave = JdbcPeriodicRefreshService.removeFromMap((Map)storedDataResult.getStoredIdToRequest(), (List)invalidatedRequests);
        Map impsToSave = JdbcPeriodicRefreshService.removeFromMap((Map)storedDataResult.getStoredIdToImp(), (List)invalidatedImps);
        return StoredDataResult.of((Map)requestsToSave, (Map)impsToSave, (List)storedDataResult.getErrors());
    }

    private static List<String> getInvalidatedKeys(Map<String, String> changesMap) {
        return changesMap.entrySet().stream().filter(entry -> StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) || StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getValue()), (CharSequence)"null")).map(Map.Entry::getKey).toList();
    }

    private static Map<String, String> removeFromMap(Map<String, String> map, List<String> invalidatedKeys) {
        return map.entrySet().stream().filter(entry -> !invalidatedKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Timeout createTimeout() {
        return this.timeoutFactory.create(this.timeout);
    }
}

