/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.settings.CacheNotificationListener;
import org.prebid.server.settings.model.StoredDataType;
import org.prebid.server.settings.proto.response.HttpRefreshResponse;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpPeriodicRefreshService
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(HttpPeriodicRefreshService.class);
    private final String refreshUrl;
    private final long refreshPeriod;
    private final long timeout;
    private final CacheNotificationListener cacheNotificationListener;
    private final Vertx vertx;
    private final HttpClient httpClient;
    private final JacksonMapper mapper;
    private Instant lastUpdateTime;

    public HttpPeriodicRefreshService(String refreshUrl, long refreshPeriod, long timeout, CacheNotificationListener cacheNotificationListener, Vertx vertx, HttpClient httpClient, JacksonMapper mapper) {
        this.refreshUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(refreshUrl));
        this.refreshPeriod = refreshPeriod;
        this.timeout = timeout;
        this.cacheNotificationListener = Objects.requireNonNull(cacheNotificationListener);
        this.vertx = Objects.requireNonNull(vertx);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void initialize() {
        this.getAll();
        if (this.refreshPeriod > 0L) {
            this.vertx.setPeriodic(this.refreshPeriod, aLong -> this.refresh());
        }
    }

    private void getAll() {
        this.httpClient.get(this.refreshUrl, this.timeout).map(arg_0 -> this.processResponse(arg_0)).map(arg_0 -> this.save(arg_0)).map(ignored -> this.setLastUpdateTime(Instant.now())).recover(HttpPeriodicRefreshService::failResponse);
    }

    private Void save(HttpRefreshResponse refreshResponse) {
        Map requests = this.parseStoredData(refreshResponse.getRequests(), StoredDataType.request);
        Map imps = this.parseStoredData(refreshResponse.getImps(), StoredDataType.imp);
        this.cacheNotificationListener.save(requests, imps);
        return null;
    }

    private Void setLastUpdateTime(Instant instant) {
        this.lastUpdateTime = instant;
        return null;
    }

    private static Future<Void> failResponse(Throwable exception) {
        logger.warn((Object)"Error occurred while request to http periodic refresh service", exception);
        return Future.failedFuture((Throwable)exception);
    }

    private HttpRefreshResponse processResponse(HttpClientResponse response) {
        HttpRefreshResponse refreshResponse;
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("HTTP status code " + statusCode);
        }
        String body = response.getBody();
        try {
            refreshResponse = (HttpRefreshResponse)this.mapper.decodeValue(body, HttpRefreshResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Cannot parse response: " + body, (Throwable)e);
        }
        return refreshResponse;
    }

    private Map<String, String> parseStoredData(Map<String, ObjectNode> refreshResponse, StoredDataType type) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ObjectNode> entry : refreshResponse.entrySet()) {
            String jsonAsString;
            String id = entry.getKey();
            try {
                jsonAsString = this.mapper.mapper().writeValueAsString((Object)entry.getValue());
            }
            catch (JsonProcessingException e) {
                throw new PreBidException("Error parsing %s json for id: %s with message: %s".formatted(type, id, e.getMessage()));
            }
            result.put(id, jsonAsString);
        }
        return result;
    }

    private void refresh() {
        Instant updateTime = Instant.now();
        String lastModifiedParam = "last-modified=" + this.lastUpdateTime;
        String andOrParam = this.refreshUrl.contains("?") ? "&" : "?";
        String refreshEndpoint = this.refreshUrl + andOrParam + lastModifiedParam;
        this.httpClient.get(refreshEndpoint, this.timeout).map(arg_0 -> this.processResponse(arg_0)).map(arg_0 -> this.invalidate(arg_0)).map(arg_0 -> this.save(arg_0)).map(ignored -> this.setLastUpdateTime(updateTime)).recover(HttpPeriodicRefreshService::failResponse);
    }

    private HttpRefreshResponse invalidate(HttpRefreshResponse refreshResponse) {
        List invalidatedRequests = HttpPeriodicRefreshService.getInvalidatedKeys((Map)refreshResponse.getRequests());
        List invalidatedImps = HttpPeriodicRefreshService.getInvalidatedKeys((Map)refreshResponse.getImps());
        if (!invalidatedRequests.isEmpty() || !invalidatedImps.isEmpty()) {
            this.cacheNotificationListener.invalidate(invalidatedRequests, invalidatedImps);
        }
        Map requestsToSave = HttpPeriodicRefreshService.removeFromMap((Map)refreshResponse.getRequests(), (List)invalidatedRequests);
        Map impsToSave = HttpPeriodicRefreshService.removeFromMap((Map)refreshResponse.getImps(), (List)invalidatedImps);
        return HttpRefreshResponse.of((Map)requestsToSave, (Map)impsToSave);
    }

    private static List<String> getInvalidatedKeys(Map<String, ObjectNode> changes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, ObjectNode> entry : changes.entrySet()) {
            ObjectNode jsonNodes = entry.getValue();
            JsonNode deleted = jsonNodes.get("deleted");
            if (deleted == null || !deleted.asBoolean()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static Map<String, ObjectNode> removeFromMap(Map<String, ObjectNode> map, List<String> invalidatedKeys) {
        HashMap<String, ObjectNode> result = new HashMap<String, ObjectNode>(map);
        for (String key : invalidatedKeys) {
            result.remove(key);
        }
        return result;
    }
}

