/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.settings.CacheNotificationListener;
import org.prebid.server.settings.model.StoredItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class SettingsCache
implements CacheNotificationListener {
    private final Map<String, Set<StoredItem>> requestCache;
    private final Map<String, Set<StoredItem>> impCache;

    public SettingsCache(int ttl, int size) {
        if (ttl <= 0 || size <= 0) {
            throw new IllegalArgumentException("ttl and size must be positive");
        }
        this.requestCache = SettingsCache.createCache((int)ttl, (int)size);
        this.impCache = SettingsCache.createCache((int)ttl, (int)size);
    }

    public static <T> Map<String, T> createCache(int ttl, int size) {
        return Caffeine.newBuilder().expireAfterWrite((long)ttl, TimeUnit.SECONDS).maximumSize((long)size).build().asMap();
    }

    Map<String, Set<StoredItem>> getRequestCache() {
        return this.requestCache;
    }

    Map<String, Set<StoredItem>> getImpCache() {
        return this.impCache;
    }

    void saveRequestCache(String accountId, String requestId, String requestValue) {
        SettingsCache.saveCachedValue((Map)this.requestCache, (String)accountId, (String)requestId, (String)requestValue);
    }

    void saveImpCache(String accountId, String impId, String impValue) {
        SettingsCache.saveCachedValue((Map)this.impCache, (String)accountId, (String)impId, (String)impValue);
    }

    private static void saveCachedValue(Map<String, Set<StoredItem>> cache, String accountId, String id, String value) {
        Set values = (Set)ObjectUtils.defaultIfNull(cache.get(id), new HashSet());
        values.add(StoredItem.of((String)accountId, (String)value));
        cache.put(id, values);
    }

    public void save(Map<String, String> requests, Map<String, String> imps) {
        if (MapUtils.isNotEmpty(requests)) {
            requests.forEach((key, value) -> this.requestCache.put(key, Collections.singleton(StoredItem.of(null, (String)value))));
        }
        if (MapUtils.isNotEmpty(imps)) {
            imps.forEach((key, value) -> this.impCache.put(key, Collections.singleton(StoredItem.of(null, (String)value))));
        }
    }

    public void invalidate(List<String> requests, List<String> imps) {
        requests.forEach(this.requestCache.keySet()::remove);
        imps.forEach(this.impCache.keySet()::remove);
    }
}

